<?php
namespace App\Http\Controllers\Dashboard;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Models\Branch;
;

class BranchController extends Controller{
    public function __construct()
    {
        $this->middleware('auth');
    }
    public function index(){
        $branchs=Branch::all();
        return view("dashboard.branch.index")->with("branchs",$branchs);
    }
    public function create(){
        return view("dashboard.branch.create");
    }

    public function store(Request $request){
        $request->validate([
            'name_en'=>'required',
            'phone'=>'required|digits:11',
            'address_en'=>'required',
            'location'=>'required',
            'name_ar'=>'required',
            'address_ar'=>'required',
        ]);
            $branch_id=Branch::create(['phone'=>$request->phone,'location'=>$request->location,'created_by'=>auth()->user()->id])->id;
            \App\Models\Arabic\Branch::create(['branch_id'=>$branch_id,'name'=>$request->name_ar,'address'=>$request->address_ar]);
            \App\Models\English\Branch::create(['branch_id'=>$branch_id,'name'=>$request->name_en,'address'=>$request->address_en]);
            return redirect(adminUrl('branch'));

    }
    public function edit($id){
        $branch=Branch::find($id);
        return view("dashboard.branch.edit")->with("branch",$branch);
    }

    public function update(Request $request,$id){
        $branch=Branch::find($id);
        $request->validate([
            'name_en'=>'required',
            'phone'=>'required|digits:11',
            'address_en'=>'required',
            'location'=>'required',
            'name_ar'=>'required',
            'address_ar'=>'required',
        ]);

        $branch->update(['phone'=>$request->phone,'location'=>$request->location,'created_by'=>auth()->user()->id]);
        \App\Models\Arabic\Branch::where('branch_id',$id)->update(['name'=>$request->name_en,'address'=>$request->address_ar]);
        \App\Models\English\Branch::where('branch_id',$id)->update(['name'=>$request->name_en,'address'=>$request->address_en]);
        return redirect(adminUrl('branch'));

    }

    public function destroy($id){
        $branch=Branch::find($id);
        $branch->delete();
        return redirect(adminUrl('branch'));
    }
}
