<?php

namespace App\Http\Controllers;

use App\Models\Appointment;
use App\Models\Branch;
use App\Models\Feature;
use App\Models\File;
use App\Models\Album;
use App\Models\Blog;
use App\Models\Gallery;
use App\Models\Contact;
use App\Models\Image;
use App\Models\Message;
use App\Models\Offer;
use App\Models\Page;
use App\Models\Slider;
use App\Models\Service;
use App\Models\Team;
use App\Models\Faq;
use App\Models\Testimonial;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Session;

class WebsitePagesController extends Controller
{
    public function index()
    {
        $og = Page::with('open_graph')->where('url','/')->first();
        $headerCode = Page::with('open_graph')->where('url', '=', '/')->first();
        $services = Service::with('service_'.currentLang(), 'parentService')->where('parent_service_id', null)->limit(9)->get();
        $subServices = Service::with('service_'.currentLang(), 'parentService')->where('parent_service_id', '!=', null)->get();
        $slides = Slider::with('slider_'.currentLang(), 'image')->get();
        $images = Gallery::with('image')->limit(8)->get();
        $aboutAlbum = Album::find(11);
        $members  = Team::with('team_en', 'team_ar', 'image')->get();
        $testimonials = Testimonial::with('testimonial_en', 'testimonial_ar')->get();
        $blogs=Blog::with('blog_en','blog_ar','image')->limit(3)->orderBy('id','DESC')->get();
        return view('website.welcome', compact( 'slides', 'images', 'services', 'subServices', 'members','testimonials','blogs', 'aboutAlbum', 'og', 'headerCode'));
    }

    public function about()
    {
        $og = Page::with('open_graph')->where('url','about')->first();
        $headerCode = Page::with('open_graph')->where('url', '=', 'about')->first();
        //$testimonials = Testimonial::with('testimonial_en', 'testimonial_ar')->get();
        //$perfect_health_album=Album::where('id',19)->first();
        $perfect_health_album=Album::where('id',27)->first();
        //dd($perfect_health_album);
        $features=Feature::all();
        return view('website.about', compact('perfect_health_album','features', 'og', 'headerCode'));
    }

     public function bio()
    {
        $og = Page::with('open_graph')->where('url','bio')->first();
        $headerCode = Page::with('open_graph')->where('url', '=', 'bio')->first();
        $testimonials = Testimonial::with('testimonial_en', 'testimonial_ar')->get();
        return view('website.bio', compact('testimonials','og', 'headerCode'));
    }


    public function team()
    {
        $og = Page::with('open_graph')->where('url','team')->first();
        $headerCode = Page::with('open_graph')->where('url', '=', 'team')->first();
        $ceo = Team::with('team_en', 'team_ar')->where('is_ceo', '!=', null)->first();
        //$testimonials = Testimonial::with('testimonial_en', 'testimonial_ar')->get();
        $members = Team::with('team_en', 'team_ar', 'image')->where('is_ceo', null)->get();
        return view('website.team', compact('members', 'ceo', 'og', 'headerCode'));
    }

    public function all_success_story(){
        $og = Page::with('open_graph')->where('url','success-story')->first();
        $headerCode = Page::with('open_graph')->where('url', '=', 'success-story')->first();
        //$ceo = Album::with('album_en', 'album_ar')->where('is_ceo', '!=', null)->first();
        //$testimonials = Testimonial::with('testimonial_en', 'testimonial_ar')->get();
        //$members = Team::with('team_en', 'team_ar', 'image')->where('is_ceo', null)->get();
        $headerCode = Page::with('open_graph')->where('url', '=', 'success-story')->first();
        $services = Service::with('images','image','service_'.currentLang())->where('parent_service_id',null)->where('status','success-story')->get();

        return view('website.all_success_story', compact('services','og','headerCode'));
    }

    public function success_story($url){
        $og = Page::with('open_graph')->where('url',$url)->first();
        $headerCode = Page::with('open_graph')->where('url', '=', $url)->first();
        //$ceo = Album::with('album_en', 'album_ar')->where('is_ceo', '!=', null)->first();
        //$testimonials = Testimonial::with('testimonial_en', 'testimonial_ar')->get();
        //$members = Team::with('team_en', 'team_ar', 'image')->where('is_ceo', null)->get();
        //$headerCode = Page::with('open_graph')->where('url', '=', 'medical-tourism')->first();
        $service = Service::with('images','image','service_'.currentLang())->where('url',$url)->first();

        return view('website.success_story', compact('service','og','headerCode'));
    }
    public function all_medical_tourism(){
        $og = Page::with('open_graph')->where('url','medical-tourism')->first();
        $headerCode = Page::with('open_graph')->where('url', '=', 'medical-tourism')->first();
        $services = Service::with('images','image','service_'.currentLang())->where('parent_service_id',null)->where('status','medical-tourism')->get();

        return view('website.all_medical_tourism', compact('services','og','headerCode'));
    }
    public function medical_tourism($url){
        $og = Page::with('open_graph')->where('url',$url)->first();
        $headerCode = Page::with('open_graph')->where('url', '=', $url)->first();
        $service = Service::with('images','image','service_'.currentLang())->where('url',$url)->first();
        return view('website.medical_tourism', compact('service','og','headerCode'));
    }

    public function reserve()
    {
        $og = Page::with('open_graph')->where('url','reserve')->first();
        $headerCode = Page::with('open_graph')->where('url', '=', 'reserve')->first();
        $testimonials = Testimonial::with('testimonial_en', 'testimonial_ar')->get();
        return view('website.reserve', compact('testimonials', 'og', 'headerCode'));
    }


    public function reserveAppointment(Request $request)
    {
        $input = Input::get();
        $this->validate($request,[
            'email'         => 'bail|required|email|max:100',
            'phone'         => 'bail|required|min:8|max:14',
            'service_id'    => 'bail|required|max:150',
            'name'          => 'bail|required|max:100',
            'message'       => 'bail|max:500',
            'gender'        => 'bail|required|int',
            'birth_date'    => 'bail|required|date',
        ], [], [
            'email'         => 'Email',
            'phone'         => 'Phone',
            'name'          => 'Name ',
            'message'       => 'Message',
            'service_id'    => 'Service',
        ]);

        $appointment = new Appointment();

        if ($uploadedFile = $request->file('file_id'))
        {
            $this->validate($request,[

                'file_id'       => 'bail|mimes:jpeg,jpg,png,gif,doc,docx,pdf,csv,xls',
            ], [], [
                'file_id'       => 'File',
            ]);
            $fileName = time() . $uploadedFile->getClientOriginalName();
            $uploadedFile->move('dashboardImages/appointments', $fileName);
            $filePath = 'dashboardImages/appointments/'.$fileName;
            $file = File::create(['name' => $fileName, 'path' => $filePath]);
            $input['file_id'] = $file->id;
            $appointment->file_id = $input['file_id'];

        }


        $appointment->name = $input['name'];
        $appointment->email = $input['email'];
        $appointment->phone = $input['phone'];
        $appointment->service_id = $input['service_id'];

        $appointment->message = $input['message'];
        $appointment->gender = $input['gender'];
        $appointment->birth_date = $input['birth_date'];
        $appointment->created_at = time();
        $appointment->updated_at = time();
        $appointment->save();

        Session::flash('create', __('trans.confirmation_msg'));
        return redirect()->back();
    }


    public function blog()
    {
        $og = Page::with('open_graph')->where('url','blog')->first();
        $headerCode = Page::with('open_graph')->where('url', '=', 'blog')->first();
        //$testimonials = Testimonial::with('testimonial_en', 'testimonial_ar')->get();
        $page=Input::get('page');
        if($page=='article'){
            $blogs = Blog::with('blog_'.currentLang(), 'image')->where('is_information',null)->orderBy('created_at', 'desc')->get();
            return view('website.blog', compact('blogs', 'og', 'headerCode'));
        } elseif($page=='important-info'){
            $blogs = Blog::with('blog_'.currentLang(), 'image')->where('is_information',1)->orderBy('created_at', 'desc')->get();
            return view('website.blog', compact('blogs', 'og', 'headerCode'));
        }else{
            $blogs = Blog::with('blog_'.currentLang(), 'image')->orderBy('created_at', 'desc')->get();
            return view('website.blog', compact('blogs', 'og', 'headerCode'));
        }
        /*$blogs = Blog::with('blog_'.currentLang(), 'image')->orderBy('created_at', 'desc')->get();
        return view('website.blog', compact('blogs', 'og', 'headerCode'));*/
    }
   /* public function importantInfo()
    {
        $og = Page::with('open_graph')->where('url','blog')->first();
        $headerCode = Page::with('open_graph')->where('url', '=', 'blog')->first();
        //$testimonials = Testimonial::with('testimonial_en', 'testimonial_ar')->get();
        $blogs = Blog::with('blog_'.currentLang(), 'image')->where('is_information',1)->orderBy('created_at', 'desc')->get();
        return view('website.blog', compact('blogs', 'og', 'headerCode'));
    }*/


    public function blogDetails($url)
    {
        $og = Page::with('open_graph')->where('url',$url)->first();
        $headerCode = Page::with('open_graph')->where('url', '=', $url)->first();
        //$testimonials = Testimonial::with('testimonial_' . currentLang(), 'image')->get();
        $blog = Blog::with('blog_'.currentLang(), 'image')->where('url', $url)->first();
        $latestPosts = Blog::with('blog_' . currentLang(), 'image')
            ->where('id', '!=', $blog->id)
            ->orderBy('created_by', 'desc')
            ->limit(6)->get();

        return view('website.blogDetails', compact('blog','latestPosts', 'og', 'headerCode'));
    }

    public function gallery()
    {
        $images = Gallery::with('image')->where('video_url', null)->get();
        return view('website.gallery', compact( 'images'));
    }

    public function video()
    {
        $og = Page::with('open_graph')->where('url','blog')->first();
        $headerCode = Page::with('open_graph')->where('url', '=', 'blog')->first();
        //$videos = Gallery::where('video_name', '!=' , null)->where('video_url', '!=', null )->get();
        $videos = Album::where('type', '=' ,2)->get();
        //dd($videos[0]->videos);
        return view('website.video', compact('videos','og','headerCode'));
    }

    public function albums($id)
    {
        $album = Album::find($id);
        $images =  Image::where('album_id', $id)->get();
        return view('website.albums', compact('album', 'images'));
    }

    public function offers()
    {
        $og = Page::with('open_graph')->where('url','offers')->first();
        $headerCode = Page::with('open_graph')->where('url', '=', 'offers')->first();
        $offers = Offer::with('image')->get();
        $testimonials = Testimonial::with('testimonial_en', 'testimonial_ar')->get();
        return view('website.offers', compact('testimonials', 'offers', 'og', 'headerCode'));
    }

    public function album()
    {
        $og = Page::with('open_graph')->where('url','album')->first();
        $headerCode = Page::with('open_graph')->where('url', '=', 'album')->first();
        //$type = Input::get('type');
        //if ($type == 'image')
       // {
            $albums = Album::with('album_en', 'album_ar', 'image')->where('type', 1)->orderBy('created_by', 'desc')->get();
           //$testimonials = Testimonial::with('testimonial_en', 'testimonial_ar')->get();

            return view('website.album', compact(  'albums', 'og', 'headerCode'));
        //}
        //elseif ($type == 'video')
        //{
          //  $albums = Album::with('album_en', 'album_ar', 'image')
            //    ->where('type', 2)
              //  ->orderBy('created_by', 'desc')->get();
            //$testimonials = Testimonial::with('testimonial_en', 'testimonial_ar')->get();
            //return view('website.album', compact(  'albums', 'og', 'headerCode'));
        //}
    }


    public function albumDetails($id)
    {
        $og = Page::with('open_graph')->where('url','album')->first();
        $headerCode = Page::with('open_graph')->where('url', '=', 'album')->first();
        $type = Input::get('type');

        //if ($type == 1)
       //{
            $imagesAlbum = Album::with('album_en', 'album_ar', 'images')->find($id);
            //$testimonials = Testimonial::with('testimonial_en', 'testimonial_ar')->get();
            $videosAlbum = null;
            return view('website.albumDetails', compact(  'imagesAlbum', 'videosAlbum',  'og', 'headerCode'));
        //}
        //elseif ($type == 2)
        //{
            //$videosAlbum = Album::with('album_en', 'album_ar', 'videos')->find($id);
            //$testimonials = Testimonial::with('testimonial_en', 'testimonial_ar')->get();
           // $imagesAlbum = null;
           // return view('website.albumDetails', compact( 'testimonials', 'videosAlbum', 'imagesAlbum',  'og', 'headerCode'));
        //}
        //else
       // {
            //return redirect()->back();
        //}

    }



    public function contact()
    {
        $og = Page::with('open_graph')->where('url','contact')->first();
        $headerCode = Page::with('open_graph')->where('url', '=', 'contact')->first();
        $testimonials = Testimonial::with('testimonial_en', 'testimonial_ar')->get();
        $contact = Contact::orderby('id', 'desc')->first();
        return view('website.contact', compact('contact', 'testimonials', 'og', 'headerCode'));
    }


    public function serviceDetails($url)
    {
        $og = Page::with('open_graph')->where('url',$url)->first();
        $headerCode = Page::with('open_graph')->where('url', '=', $url)->first();
        $testimonials = Testimonial::with('testimonial_en', 'testimonial_ar')->get();
        $singleService = Service::with('service_'.currentLang(), 'image')->where('url', $url)->first();
        return view('website.serviceDetails', compact('singleService', 'testimonials', 'og', 'headerCode'));
    }



    public function message(Request $request)
    {
        $input = Input::get();
        $this->validate($request,[
            'email'         => 'bail|required|email|max:100',
            'phone'         => 'bail|required|min:8|max:14',
            'title'         => 'bail|required|max:150',
            'name'          => 'bail|required|max:100',
            'message'       => 'bail|required|min:30|max:500',
            'file_id'       => 'bail|mimes:jpeg,jpg,png,gif,doc,docx,pdf,csv,xls',
        ], [], [
            'email'         => 'Email',
            'phone'         => 'Phone',
            'name'          => 'Name ',
            'message'       => 'Message',
        ]);

        $message = new Message;

        if ($uploadedFile = $request->file('file_id'))
        {
            $fileName = time() . $uploadedFile->getClientOriginalName();
            $uploadedFile->move('dashboardImages/contactFiles', $fileName);
            $filePath = 'dashboardImages/contactFiles/'.$fileName;
            $file = File::create(['name' => $fileName, 'path' => $filePath]);
            $input['file_id'] = $file->id;
            $message->file_id = $input['file_id'];
        }


        $message->name = $input['name'];
        $message->email = $input['email'];
        $message->phone = $input['phone'];
        $message->title = $input['title'];
        $message->message = $input['message'];

        $message->save();
        Session::flash('create', __('trans.thanks_msg'));
        return redirect()->back();
    }

    public function branch()
    {
        $og = Page::with('open_graph')->where('url','contact')->first();
        $headerCode = Page::with('open_graph')->where('url', '=', 'contact')->first();
        $branchs = Branch::orderby('id', 'desc')->get();
        return view('website.contact', compact('branchs', 'og', 'headerCode'));
    }


  /* 
     public function service()
     {
         $shows = Show::with('ThumbImg', 'mainImg')->get();
         return view('website.shows', compact('shows'));
     }
     */
      public function services()
    {
            return view('website.all_services');
    }

     
     public function question(){
        $og = Page::with('open_graph')->where('url','faq')->first();
        $headerCode = Page::with('open_graph')->where('url', '=', 'faq')->first();
       $faqs = Faq::with('faq_'.currentLang())->get();
        return view('website.questions', compact('og', 'headerCode','faqs'));
    }


}

























