<?php
/**
 * Created by PhpStorm.
 * User: Kidwany
 * Date: 1/14/2019
 * Time: 7:52 PM
 */

namespace App\Http\ViewComposers;

use App\Models\Contact;
use App\Models\About;
use App\Models\Page;
use App\Models\Same_a;
use App\Models\Setting;
use App\Models\Service;
use App\Models\Working_day;
use  Illuminate\View\View;

class LayoutsComposer
{
    public function compose(View $view)
    {

        // Return Projects In the footer of all pages

        //retrieve Projects in footer
        $contact = Contact::orderby('id', 'desc')->first();
        $about = About::with('about_'.currentLang())->orderBy('created_at', 'desc')->first();
        $setting = Setting::with( 'image')->orderBy('created_at', 'desc')->first();
        $mainServices = Service::with('service_'.currentLang(), 'childService')->where('parent_service_id', null)->where('status',null)->get();
        $workingDays = Working_day::with('working_days_en', 'working_days_en')->orderBy('created_at', 'desc')->first();
        $sameAs = Same_a::all();
        $mainOpenGraph = Page::with('open_graph')->where('url', '/')->first();

        $view->with('contact', $contact)
                ->with('about', $about)
                ->with('setting', $setting)
                ->with('mainServices', $mainServices)
                ->with('sameAs', $sameAs)
                ->with('mainOpenGraph', $mainOpenGraph)
                ->with('workingDays', $workingDays);
    }
}
