<?php

class Home extends Controller
{


    public function index()
    {
        /******** start header code ********/
        if (FALSE !== $this->loadHelper("UserHelper")->check_user_login()) {
            // get user id from session
            $user_id = $this->loadSession()->getSession("user_id");
            // get user data for header
            $dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id", $user_id);
            if ($dataView['userData'] == NULL) {
                $this->redirect("error", "index");
                exit();
            }
        } else {
            $this->redirect("admin", "login");
        }

        /******* end header code *******/
        $dataView['today_date'] = date('Y-m-d');
        $dataView['month_date'] = date('Y-m-01');
        $dataView['tomorowDay'] = date('Y-m-d', strtotime(' +1 day'));
        $dataView['next1Day'] = date('Y-m-d', strtotime(' +2 day'));
        $dataView['next7Day'] = date('Y-m-d', strtotime(' +7 day'));

        $dataView['before1Day'] = date('Y-m-d', strtotime(' -1 day'));
        $dataView['before2Day'] = date('Y-m-d', strtotime(' -2 day'));
        $dataView['before3Day'] = date('Y-m-d', strtotime(' -3 day'));

        $dataView['total_gallery'] = $this->loadModel("GalleryModel")->retrieveDataByQuery("SELECT COUNT(`id`) as `count` FROM `gallery` WHERE `deleted` =?", array(1));
        $dataView['total_services'] = $this->loadModel("ServiceModel")->retrieveDataByQuery("SELECT COUNT(`id`) as `count` FROM `service` WHERE `deleted` =?", array(1));
        $dataView['total_messages'] = $this->loadModel("UserMessageModel")->retrieveDataByQuery("SELECT COUNT(`id`) as `count` FROM `user_message` WHERE `deleted` =?", array(1));
        $dataView['sum_messages'] = $this->loadModel("UserMessageModel")->retrieveDataByQuery("SELECT * FROM `user_message` WHERE `deleted` =?  ORDER BY `id` DESC LIMIT 5  ", array(1));
        $dataView['total_employees'] = $this->loadModel("UserModel")->retrieveDataByQuery("SELECT COUNT(`id`) as `count` FROM `user` WHERE `job_type` = ? AND `deleted` =?", array(1, 1));
        $dataView['total_users'] = $this->loadModel("UserModel")->retrieveDataByQuery("SELECT COUNT(`id`) as `count` FROM `user` WHERE `deleted` =?", array(1));
        $dataView['total_active_users'] = $this->loadModel("UserModel")->retrieveDataByQuery("SELECT COUNT(`id`) as `count` FROM `user` WHERE `status` =? AND `deleted` =?", array(1, 1));
        $dataView['total_un_active_users'] = $this->loadModel("UserModel")->retrieveDataByQuery("SELECT COUNT(`id`) as `count` FROM `user` WHERE `status` =? AND `deleted` =?", array(2, 1));
        $dataView['today_requests_count'] = $this->loadModel("RequestModel")->retrieveDataByQuery("SELECT COUNT(`id`) as `count` FROM `request` WHERE `createdAt` >= ? AND `status` =? AND `deleted` =?", array($dataView['today_date'], 1, 1));
        $dataView['month_requests_count'] = $this->loadModel("RequestModel")->retrieveDataByQuery("SELECT COUNT(`id`) as `count` FROM `request` WHERE `createdAt` >= ? AND `status` =? AND `deleted` =?", array($dataView['month_date'], 1, 1));


        $dataView['today_orders'] = $this->loadModel("RequestModel")->retrieveDataByQuery("SELECT COUNT(`id`) as `count` FROM `request` WHERE `createdAt` >= ? AND `status` =? AND `deleted` =?", array($dataView['today_date'], 1, 1));

        $dataView['before1DayOrders'] = $this->loadModel("RequestModel")->retrieveDataByQuery("SELECT COUNT(`id`) as `count` FROM `request` WHERE `createdAt` BETWEEN ? AND ? AND `status` =? AND `deleted` =?", array($dataView['before1Day'], $dataView['today_date'], 1, 1));
        $dataView['before2DayOrders'] = $this->loadModel("RequestModel")->retrieveDataByQuery("SELECT COUNT(`id`) as `count` FROM `request` WHERE `createdAt` BETWEEN ? AND ? AND `status` =? AND `deleted` =?", array($dataView['before2Day'], $dataView['before1Day'], 1, 1));
        $dataView['before3DayOrders'] = $this->loadModel("RequestModel")->retrieveDataByQuery("SELECT COUNT(`id`) as `count` FROM `request` WHERE `createdAt` BETWEEN ? AND ? AND `status` =? AND `deleted` =?", array($dataView['before3Day'], $dataView['before2Day'], 1, 1));

        $dataView['activeUsersCount'] = ($dataView['total_users'][0]['count'] != 0) ? ($dataView['total_active_users'][0]['count'] / $dataView['total_users'][0]['count']) : 0;
        $dataView['unActiveUsersCount'] = ($dataView['total_users'][0]['count'] != 0) ? ($dataView['total_un_active_users'][0]['count'] / $dataView['total_users'][0]['count']) : 0;
        $dataView['requests'] = $this->loadModel("RequestModel")->retrieveAllData("WHERE `createdAt` >= ? AND `deleted` =?", array($dataView['today_date'], 1));

        // get all Data
        $dataView['servicesHome'] = $this->loadModel("ServiceModel")->retrieveAllData("WHERE `deleted` =? ORDER BY `id` DESC LIMIT 4", array(1));


        $dataView['title'] = "Home Page";
        // global Template Config
        global $TEMPLATE_BACK_END;
        // set content
        $TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH . "home_page";
        // load template
        $this->loadTemplate($TEMPLATE_BACK_END, $dataView)->render();
    }

}

?>
