@extends('website.layouts.layouts')
@section('title', __('trans.about'))

@section('open-graph')
    <meta name="description" content="{{$og->description ? $og->description : $mainOpenGraph->description}}">
    <meta name="keywords" content="{{$og->key_words ? $og->key_words : $mainOpenGraph->key_words}}">
    <!-- open graph meta-->
    <meta property="og:title" content="{{$og->open_graph->og_title ? $og->open_graph->og_title : $mainOpenGraph->open_graph->og_title}}"/>
    <meta property="og:type" content="{{$og->open_graph->og_type ? $og->open_graph->og_type : $mainOpenGraph->open_graph->og_type}}"/>
    <meta property="og:url" content="{{url($og->url)}}"/>
    <meta property="og:image" content="
    @if($og->open_graph->image_url)
    {{$og->open_graph->image_url}}
    @elseif($og->open_graph->open_graph_image)
    {{asset($og->open_graph->open_graph_image->path)}}
    @else
    {{$mainOpenGraph->open_graph->image_url}}
    @endif
    {{--{{$object->open_graph->image_url ? $object->open_graph->image_url : asset($object->open_graph->open_graph_image->path)}}--}}"
    />
    <meta property="og:description" content="{{$og->open_graph->og_description ? $og->open_graph->og_description : $mainOpenGraph->open_graph->og_description}}"/>
    <meta property="og:site_name" content="{{$og->open_graph->og_site_name ? $og->open_graph->og_site_name : $mainOpenGraph->open_graph->og_site_name}}"/>
@endsection

@section('canonical')
    <link rel="canonical" href="{{url($og->url)}}"/>
@endsection

@section('header-code')
    {!! $headerCode->header_code ? $headerCode->header_code : '' !!}
@endsection


@section('customizedStyle')
    <style>

    </style>
    @endsection

@section('customizedScript')
    <script>
        $("li .about-album:first-child").addClass('active');
       $(".item:first-child").addClass('active');

    </script>
    @endsection
@section('content')


    <!--============= Start banner =============-->
    <section class="banner text-center">
        <div class="overlay">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12">
                        <div class="info">
                            <h2>{{--عن الدكتور محمد ابوزيد--}}
                                {{__("trans.website_title")}}
                            </h2>
                            <div class="navigation">
                                <ol class="breadcrumb">
                                    <li><a href="index.html">{{--الرئيسية--}}
                                            {{__("trans.home")}}
                                        </a></li>
                                    <li><a href="about.html">{{--عن الدكتور--}}
                                            {{__("trans.about")}}
                                        </a></li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============= End banner =============-->

    <!--============= Start main_info =============-->
    <section class="main_info">
        <div class="container"><!--Start Container-->
            <div class="row"><!--Start row-->

                <div class="col-md-8 col-xs-12">
                    <div class="head_info">
                        <h3 class="wow fadeInRight">
                            {{--بيرفيكت هيلث--}}
                           {{__("trans.perfect_health")}}
                            <hr>
                        </h3>
                        <p class="wow fadeInRight" data-wow-duration="1.5s">
{{--
                            بدأ أ. د.محمد محمود ابوزيد جراحات السمنة المفرطة فى اوائل الالفيه و كون خبرة واسعة فى جميع أنواع جراحات السمنة و لاحظ فى هذا الوقت أن نسبة المضاعفات عاليه و ان معظم جراحي السمنه في هذا الوقت يجرون الجراحات بفتح جراحي و نادرا ما يستخدمون المنظار
--}}
                            {!! $about->{'about_'.currentLang()}->description !!}

                        </p>
                    </div>
                </div>

                <div class="col-md-4 col-xs-12">
                    <div id="carousel-example-generic" class="carousel slide wow fadeInLeft" data-ride="carousel">
                        <!-- Indicators -->
                        <ol class="carousel-indicators">
                            @if($perfect_health_album)
                                @php($count=0)
                                @foreach($perfect_health_album->images as $perfect_health)
                                    <li data-target="#carousel-example-generic" data-`slide`-to="{{$count}}" class="about-album "></li>
                                    @php($count++)
                                @endforeach
                            @else
                            @endif
                           {{-- <li data-target="#carousel-example-generic" data-`slide`-to="0" class="active"></li>
                            <li data-target="#carousel-example-generic" data-slide-to="1"></li>
                            <li data-target="#carousel-example-generic" data-slide-to="2"></li>--}}
                        </ol>

                        <!-- Wrapper for slides -->
                        <div class="carousel-inner" role="listbox">
                            @if($perfect_health_album)
                                @foreach($perfect_health_album->images as $perfect_health)
                                    <div class="item">
                                        <img src="{{$perfect_health->path}}" alt="...">
                                    </div>
                                @endforeach
                            @else
                            @endif

                            {{--<div class="item active">
                                <img src="imgs/team/1.JPG" alt="...">
                            </div>

                            <div class="item">
                                <img src="imgs/team/2.jpg" alt="...">
                            </div>

                            <div class="item">
                                <img src="imgs/team/3.jpg" alt="...">
                            </div>--}}

                        </div>
                    </div>
                </div>

            </div><!--End row-->
        </div><!--End Container-->
    </section>
    <!--============= End main_info =============-->

    <!--============= Start about_feats =============-->
    <section class="about_feats">
        <div class="overlay"><!--Start overlay-->
            <div class="container"><!--Start Container-->
                <div class="row"><!--Start row-->
                    @if($features)
                        @foreach($features as $feature)
                            <div class="col-md-3 col-sm-6 col-xs-6">
                                <div class="single_feats wow flipInX" data-wow-duration="2s">
                                    <img src="{{$feature->image->path}}" alt="">
                                    <h4>{{$feature->{'feature_'.currentLang()}->title}}</h4>
                                </div>
                            </div>
                        @endforeach
                    @else
                    @endif

                   {{-- <div class="col-md-3 col-sm-6 col-xs-6">
                        <div class="single_feats wow flipInX" data-wow-duration="2s">
                            <img src="imgs/about_icon/clean.png" alt="">
                            <h4>teeth whitening</h4>
                        </div>
                    </div>

                    <div class="col-md-3 col-sm-6 col-xs-6">
                        <div class="single_feats wow flipInX" data-wow-duration="2s">
                            <img src="imgs/about_icon/washing.png" alt="">
                            <h4>cleaning of teeth</h4>
                        </div>
                    </div>

                    <div class="col-md-3 col-sm-6 col-xs-6">
                        <div class="single_feats wow flipInX" data-wow-duration="2s">
                            <img src="imgs/about_icon/qualit.png" alt="">
                            <h4>quality brackets</h4>
                        </div>
                    </div>

                    <div class="col-md-3 col-sm-6 col-xs-6">
                        <div class="single_feats wow flipInX" data-wow-duration="2s">
                            <img src="imgs/about_icon/cert.png" alt="">
                            <h4>certified dentists</h4>
                        </div>
                    </div>--}}

                </div><!--End row-->
            </div><!--End Container-->
        </div><!--End overlay-->
    </section>
    <!--============= End about_feats =============-->

    <!--============= Start nour =============-->
    <section class="nour">
        <div class="container"><!--Start Container-->
            <div class="row"><!--Start row-->

                <div class="col-md-6 col-xs-12">
                    <div class="nour_img project wow fadeInLeft" data-wow-duration="2s">
                        {{--<img src="imgs/dr-about.JPG" alt="">--}}
                        <img src="{{assetPath($about->valuesImage->path)}}" alt="">
                        <ul class="list-unstyled list-inline">
                            <li>
                                <a href="#" target="_blank"><i class="fa fa-facebook fa-fw"></i></a>
                            </li>
                            <li>
                                <a href="#" target="_blank"><i class="fa fa-twitter fa-fw"></i></a>
                            </li>
                            <li>
                                <a href="#" target="_blank"><i class="fa fa-google-plus fa-fw"></i></a>
                            </li>
                            <li>
                                <a href="#" target="_blank"><i class="fa fa-instagram fa-fw"></i></a>
                            </li>
                        </ul>
                    </div>
                </div>

                <div class="col-md-6 col-xs-12">
                    <div class="nour_info">
                        <h3 class="wow fadeInRight" data-wow-duration="1s">
                            {{--د.محمد ابوزيد--}}
                            {{__("trans.about")}}
                            <hr>
                        </h3>
                        {!!  $about->{'about_'.currentLang()}->value !!}
                        {{--<p class="wow fadeInRight" data-wow-duration="1.5s">
                            بدأ أ. د.محمد محمود ابوزيد جراحات السمنة المفرطة فى اوائل الالفيه و كون خبرة واسعة فى جميع أنواع جراحات السمنة و لاحظ فى هذا الوقت أن نسبة المضاعفات عاليه و ان معظم جراحي السمنه في هذا الوقت يجرون الجراحات بفتح جراحي و نادرا ما يستخدمون المنظار
                        </p>
                        <ul class="list-unstyled wow fadeInRight" data-wow-duration="2s">
                            <li>
                                <i class="fa fa-certificate fa-fw"></i>
                                <span>بدأ أ. د.محمد محمود ابوزيد جراحات السمنة المفرطة فى اوائل الالفيه.</span>
                            </li>
                            <li>
                                <i class="fa fa-certificate fa-fw"></i>
                                <span>كون خبرة واسعة فى جميع أنواع جراحات السمنة.</span>
                            </li>
                            <li>
                                <i class="fa fa-certificate fa-fw"></i>
                                <span>لاحظ فى هذا الوقت أن نسبة المضاعفات عاليه .</span>
                            </li>
                            <li>
                                <i class="fa fa-certificate fa-fw"></i>
                                <span>ان معظم جراحي السمنه في هذا الوقت يجرون الجراحات بفتح جراحي.</span>
                            </li>
                            <li>
                                <i class="fa fa-certificate fa-fw"></i>
                                <span>نادرا ما يستخدمون المنظار</span>
                            </li>
                        </ul>--}}
                    </div>
                </div>

            </div><!--End row-->
        </div><!--End Container-->
    </section>
    <!--============= End nour =============-->


@endsection
