@extends('website.layouts.layouts')
@section('title', __('trans.patient_info'))

@section('open-graph')
    <meta name="description" content="{{$og->description ? $og->description : $mainOpenGraph->description}}">
    <meta name="keywords" content="{{$og->key_words ? $og->key_words : $mainOpenGraph->key_words}}">
    <!-- open graph meta-->
    <meta property="og:title" content="{{$og->open_graph->og_title ? $og->open_graph->og_title : $mainOpenGraph->open_graph->og_title}}"/>
    <meta property="og:type" content="{{$og->open_graph->og_type ? $og->open_graph->og_type : $mainOpenGraph->open_graph->og_type}}"/>
    <meta property="og:url" content="{{url($og->url)}}"/>
    <meta property="og:image" content="
    @if($og->open_graph->image_url)
    {{$og->open_graph->image_url}}
    @elseif($og->open_graph->open_graph_image)
    {{asset($og->open_graph->open_graph_image->path)}}
    @else
    {{$mainOpenGraph->open_graph->image_url}}
    @endif
    {{--{{$object->open_graph->image_url ? $object->open_graph->image_url : asset($object->open_graph->open_graph_image->path)}}--}}"
    />
    <meta property="og:description" content="{{$og->open_graph->og_description ? $og->open_graph->og_description : $mainOpenGraph->open_graph->og_description}}"/>
    <meta property="og:site_name" content="{{$og->open_graph->og_site_name ? $og->open_graph->og_site_name : $mainOpenGraph->open_graph->og_site_name}}"/>
@endsection

@section('canonical')
    <link rel="canonical" href="{{url($og->url)}}"/>
@endsection

@section('header-code')
    {!! $headerCode->header_code ? $headerCode->header_code : '' !!}
@endsection

@section('content')


    <!--============= Start banner =============-->
    <section class="banner text-center">
        <div class="overlay">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12">
                        <div class="info">
                            <h2>{{--عن الدكتور محمد ابوزيد--}}{{__("trans.website_title")}}</h2>
                            <div class="navigation">
                                <ol class="breadcrumb">
                                    <li><a href="{{url('/')}}">{{--الرئيسية--}}{{__("trans.home")}}</a></li>
                                    <li><a href="{{url("/blog")}}">{{--الأخبار--}}{{__("trans.article")}}</a></li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============= End banner =============-->
    <!--============= Start about_page =============-->
    <div class="blog_area">
        <div class="overlay-1">
            <div class="container">
                <div class="pattern-layer"></div>
                <div class="bar-hed text-center">
                    <h2 class=" text-center">{{--المقالات--}}{{__("trans.articles")}} </h2>

                </div>
                <div class="row justify-content-center">
                    @if($blogs)
                        @foreach($blogs as $blog)
                            <div class="col-lg-4 col-md-6 col-sm-12">
                                <a href="{{url("blog/".$blog->url)}}"></a>
                                <div class="blog_box"><a href="{{url("blog/".$blog->url)}}">
                                        <div class="blog_img"><img src="{{$blog->image->path}}" alt="{{$blog->image->alt}}"></div>
                                    </a>
                                    <div class="blog_content"><a href="{{url("blog/".$blog->url)}}"></a>
                                        <div class="blog_meta">
                                            <a href="{{url("blog/".$blog->url)}}"></a>
                                            <a href="{{url("blog/".$blog->url)}}" class="date">
                                                {{--<h2>28</h2>
                                                <span>اكتوبر</span>--}}
                                                {{--<h2>{{$blog->created_at->format("d")}}</h2>
                                                <span>{{$blog->created_at->format("M")}}</span>--}}
                                            </a>

                                        </div>
                                        <a href="{{url("blog/".$blog->url)}}">
                                            <h4>{{$blog->{'blog_'.currentLang()}->title}}</h4>
                                            <p>{!!  strip_tags(str_limit($blog->{'blog_'.currentLang()}->body,'100','.'))!!}</p>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    @else
                    @endif
                    {{--<div class="col-lg-4 col-md-6 col-sm-12">
                        <a href="blog_details.html"></a>
                        <div class="blog_box"><a href="blog_details.html">
                                <div class="blog_img"><img src="imgs/blog/blog-1.png" alt=""></div>
                            </a>
                            <div class="blog_content"><a href="blog_details.html">
                                </a>
                                <div class="blog_meta"><a href="blog_details.html">
                                    </a><a href="blog_details.html" class="date">
                                        <h2>28</h2>
                                        <span>اكتوبر</span>
                                    </a>

                                </div>
                                <a href="blog_details.html">
                                    <h4>شكل جديد .. حياة سعيدة</h4>
                                    <p>تحت اشراف نخبة من اساتذة الجامعات تقدم جمييع الخدمات لكافة التخصصات الطبية بما فيها خدمة المعمل..</p>
                                </a>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6 col-sm-12">
                        <a href="blog_details.html">
                        </a>
                        <div class="blog_box">
                            <a href="blog_details.html">
                                <div class="blog_img"><img src="imgs/blog/blog-2.png" alt=""></div>
                            </a>
                            <div class="blog_content"><a href="blog_details.html">
                                </a>
                                <div class="blog_meta"><a href="blog_details.html">
                                    </a><a href="blog_details.html" class="date">
                                        <h2>18</h2>
                                        <span>مارس</span>
                                    </a>

                                </div>
                                <a href="blog_details.html">
                                    <h4>تأثير السمنة المفرطة</h4>
                                    <p>تحت اشراف نخبة من اساتذة الجامعات تقدم جمييع الخدمات لكافة التخصصات الطبية بما فيها خدمة المعمل..</p>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 col-sm-12">
                        <a href="blog_details.html"> </a>
                        <div class="blog_box"><a href="blog_details.html">
                                <div class="blog_img"><img src="imgs/blog/blog-3.png" alt=""></div>
                            </a>
                            <div class="blog_content"><a href="blog_details.html">
                                </a>
                                <div class="blog_meta"><a href="blog_details.html">
                                    </a><a href="blog_details.html" class="date">
                                        <h2>17</h2>
                                        <span>فبراير</span>
                                    </a>

                                </div>

                                <a href="blog_details.html">
                                    <h4>حظر الدهون المتحولة يقلل من المخاطر الصحية</h4>
                                    <p>تحت اشراف نخبة من اساتذة الجامعات تقدم جمييع الخدمات لكافة التخصصات الطبية بما فيها خدمة المعمل..</p>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 col-sm-12">
                        <a href="blog_details.html"></a>
                        <div class="blog_box"><a href="blog_details.html">
                                <div class="blog_img"><img src="imgs/blog/blog-1.png" alt=""></div>
                            </a>
                            <div class="blog_content"><a href="blog_details.html">
                                </a>
                                <div class="blog_meta"><a href="blog_details.html">
                                    </a><a href="blog_details.html" class="date">
                                        <h2>28</h2>
                                        <span>اكتوبر</span>
                                    </a>

                                </div>
                                <a href="blog_details.html">
                                    <h4>شكل جديد .. حياة سعيدة</h4>
                                    <p>تحت اشراف نخبة من اساتذة الجامعات تقدم جمييع الخدمات لكافة التخصصات الطبية بما فيها خدمة المعمل..</p>
                                </a>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6 col-sm-12">
                        <a href="blog_details.html">
                        </a>
                        <div class="blog_box">
                            <a href="blog_details.html">
                                <div class="blog_img"><img src="imgs/blog/blog-2.png" alt=""></div>
                            </a>
                            <div class="blog_content"><a href="blog_details.html">
                                </a>
                                <div class="blog_meta"><a href="blog_details.html">
                                    </a><a href="blog_details.html" class="date">
                                        <h2>18</h2>
                                        <span>مارس</span>
                                    </a>

                                </div>
                                <a href="blog_details.html">
                                    <h4>تأثير السمنة المفرطة</h4>
                                    <p>تحت اشراف نخبة من اساتذة الجامعات تقدم جمييع الخدمات لكافة التخصصات الطبية بما فيها خدمة المعمل..</p>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 col-sm-12">
                        <a href="blog_details.html"> </a>
                        <div class="blog_box"><a href="blog_details.html">
                                <div class="blog_img"><img src="imgs/blog/blog-3.png" alt=""></div>
                            </a>
                            <div class="blog_content"><a href="blog_details.html">
                                </a>
                                <div class="blog_meta"><a href="blog_details.html">
                                    </a><a href="blog_details.html" class="date">
                                        <h2>17</h2>
                                        <span>فبراير</span>
                                    </a>

                                </div>

                                <a href="blog_details.html">
                                    <h4>حظر الدهون المتحولة يقلل من المخاطر الصحية</h4>
                                    <p>تحت اشراف نخبة من اساتذة الجامعات تقدم جمييع الخدمات لكافة التخصصات الطبية بما فيها خدمة المعمل..</p>
                                </a>
                            </div>
                        </div>
                    </div>--}}

                </div>

            </div>
        </div>
    </div>
    <!--============ End about_page ============-->
@endsection
