@extends('website.layouts.layouts')
@section('title', $service->{'service_'.currentLang()}->title)

@section('open-graph')
    <meta name="description" content="{{$og->description ? $og->description : $mainOpenGraph->description}}">
    <meta name="keywords" content="{{$og->key_words ? $og->key_words : $mainOpenGraph->key_words}}">
    <!-- open graph meta-->
    <meta property="og:title" content="{{$og->open_graph->og_title ? $og->open_graph->og_title : $mainOpenGraph->open_graph->og_title}}"/>
    <meta property="og:type" content="{{$og->open_graph->og_type ? $og->open_graph->og_type : $mainOpenGraph->open_graph->og_type}}"/>
    <meta property="og:url" content="{{url($og->url)}}"/>
    <meta property="og:image" content="
    @if($og->open_graph->image_url)
    {{$og->open_graph->image_url}}
    @elseif($og->open_graph->open_graph_image)
    {{asset($og->open_graph->open_graph_image->path)}}
    @else
    {{$mainOpenGraph->open_graph->image_url}}
    @endif
    {{--{{$object->open_graph->image_url ? $object->open_graph->image_url : asset($object->open_graph->open_graph_image->path)}}--}}"
    />
    <meta property="og:description" content="{{$og->open_graph->og_description ? $og->open_graph->og_description : $mainOpenGraph->open_graph->og_description}}"/>
    <meta property="og:site_name" content="{{$og->open_graph->og_site_name ? $og->open_graph->og_site_name : $mainOpenGraph->open_graph->og_site_name}}"/>
@endsection

@section('canonical')
    <link rel="canonical" href="{{url($og->url)}}"/>
@endsection

@section('header-code')
    {!! $headerCode->header_code ? $headerCode->header_code : '' !!}
@endsection

@section('content')


    <!--============= Start banner =============-->
    <section class="banner text-center">
        <div class="overlay">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12">
                        <div class="info">
                            <h2>{{--عن الدكتور محمد ابوزيد--}}{{__("trans.website_title")}}</h2>
                            <div class="navigation">
                                <ol class="breadcrumb">
                                    <li><a href="{{url("/")}}">{{--الرئيسية--}}{{__("trans.home")}}</a></li>
                                    <li><a href="{{url("/medical-tourism")}}"> {{--السياحة العلاجية--}}{{__("trans.medical_tourism")}}</a></li>
                                    <li><a href="{{url("/medical-tourism/".$service->url)}}"> {{$service->{'service_'.currentLang()}->title}}</a></li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============= End banner =============-->
    <!--============= Start about_page =============-->
    <section class="main_info">
        <div class="container">
            <div class="row">



                <div class="col-md-7 col-sm-12">
                    <div class="head_info">
                        <h3 class="wow fadeInRight" data-wow-duration="1.5s">
                            <!---{{--السياحة العلاجية لمركز دكتور محمد ابوزيد--}}{{__("trans.dr_abouzeid_medical_tourism")}}---->
                                {{$service->{'service_'.currentLang()}->title}}
                            <hr>
                        </h3>
                       {{-- <p class="wow fadeInRight" data-wow-duration="2s">
                            بدأ أ. د.محمد محمود ابوزيد جراحات السمنة المفرطة فى اوائل الالفيه و كون خبرة واسعة فى جميع أنواع جراحات السمنة و لاحظ فى هذا الوقت أن نسبة المضاعفات عاليه و ان معظم جراحي السمنه في هذا الوقت يجرون الجراحات بفتح جراحي و نادرا ما يستخدمون المنظار
                        </p>--}}
                        {{--{{ $about? strip_tags(str_limit($about->{'about_'.currentLang()}->description,500,'...')):'' }}--}}
                        {{--{!!  $about? str_limit($about->{'about_'.currentLang()}->description,500,'...'):'' !!}--}}
                        {{-- {!! $about->{'about_'.currentLang()}->vision !!}--}}
                        {!! $service->{'service_'.currentLang()}->description !!}
                    </div>
                </div>
                <div class="col-md-5 col-sm-12">
                    <iframe width="100%" height="300" src="{{$about->video_url?$about->video_url:"https://www.youtube.com/embed/_Y6Ttq2l6zM--"}}{{--https://www.youtube.com/embed/_Y6Ttq2l6zM--}}" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                </div>
            </div>
        </div>
    </section>
    <!--============ End about_page ============-->
    <section class="gallery-section">
        <div class="container">

            <div class="sortable-masonry">



                <div class="items-container row">
                    @if($service)
                        @foreach($service->images as $image)
                            <div class="gallery-item all masonry-item loft single-home col-lg-3 col-md-4 col-sm-12">
                                <div class="image-box">
                                    <a href="{{assetPath($image->path)}}" class="lightbox-image link" data-fancybox="gallery"><figure class="image"><img src="{{assetPath($image->path)}}" alt=""></figure>
                                        <div class="overlay-box">
                                            <div class="inner">
                                                <span class="fas fa-search" style="color: #de74cc"></span>
                                            </div>
                                        </div>
                                    </a>
                                </div>
                            </div>
                        @endforeach
                    @else
                    @endif
                    {{--<div class="gallery-item all masonry-item loft single-home col-lg-3 col-md-4 col-sm-12">
                        <div class="image-box">
                            <a href="imgs/gallery/gallery-1.jpg" class="lightbox-image link" data-fancybox="gallery"><figure class="image"><img src="imgs/gallery/gallery-1.jpg" alt=""></figure>
                                <div class="overlay-box">
                                    <div class="inner">
                                        <span class="fas fa-search" style="color: #de74cc"></span>

                                    </div>
                                </div> </a>
                        </div>
                    </div>
                    <div class="gallery-item all masonry-item loft single-home col-lg-3 col-md-4 col-sm-12">
                        <div class="image-box">
                            <a href="imgs/gallery/gallery-2.jpg" class="lightbox-image link" data-fancybox="gallery"><figure class="image"><img src="imgs/gallery/gallery-2.jpg" alt=""></figure>
                                <div class="overlay-box">
                                    <div class="inner">
                                        <span class="fas fa-search" style="color: #de74cc"></span>

                                    </div>
                                </div> </a>
                        </div>
                    </div>
                    <div class="gallery-item all masonry-item loft single-home col-lg-3 col-md-4 col-sm-12">
                        <div class="image-box">
                            <a href="imgs/gallery/gallery-3.jpg" class="lightbox-image link" data-fancybox="gallery"><figure class="image"><img src="imgs/gallery/gallery-3.jpg" data-src="" alt=""></figure>
                                <div class="overlay-box">
                                    <div class="inner">
                                        <span class="fas fa-search" style="color: #de74cc"></span>

                                    </div>
                                </div> </a>
                        </div>
                    </div>
                    <div class="gallery-item all masonry-item loft single-home col-lg-3 col-md-4 col-sm-12">
                        <div class="image-box">
                            <a href="imgs/gallery/gallery-4.jpg" class="lightbox-image link" data-fancybox="gallery"><figure class="image"><img src="imgs/gallery/gallery-4.jpg" data-src="" alt=""></figure>
                                <div class="overlay-box">
                                    <div class="inner">
                                        <span class="fas fa-search" style="color: #de74cc"></span>

                                    </div>
                                </div> </a>
                        </div>
                    </div>
                    3--}}




                </div>
            </div>

        </div>
    </section>


@endsection
