@extends('website.layouts.layouts')
@section('title', __('trans.patient_info'))

@section('open-graph')
    <meta name="description" content="{{$og->description ? $og->description : $mainOpenGraph->description}}">
    <meta name="keywords" content="{{$og->key_words ? $og->key_words : $mainOpenGraph->key_words}}">
    <!-- open graph meta-->
    <meta property="og:title" content="{{$og->open_graph->og_title ? $og->open_graph->og_title : $mainOpenGraph->open_graph->og_title}}"/>
    <meta property="og:type" content="{{$og->open_graph->og_type ? $og->open_graph->og_type : $mainOpenGraph->open_graph->og_type}}"/>
    <meta property="og:url" content="{{url($og->url)}}"/>
    <meta property="og:image" content="
    @if($og->open_graph->image_url)
    {{$og->open_graph->image_url}}
    @elseif($og->open_graph->open_graph_image)
    {{asset($og->open_graph->open_graph_image->path)}}
    @else
    {{$mainOpenGraph->open_graph->image_url}}
    @endif
    {{--{{$object->open_graph->image_url ? $object->open_graph->image_url : asset($object->open_graph->open_graph_image->path)}}--}}"
    />
    <meta property="og:description" content="{{$og->open_graph->og_description ? $og->open_graph->og_description : $mainOpenGraph->open_graph->og_description}}"/>
    <meta property="og:site_name" content="{{$og->open_graph->og_site_name ? $og->open_graph->og_site_name : $mainOpenGraph->open_graph->og_site_name}}"/>
@endsection

@section('canonical')
    <link rel="canonical" href="{{url($og->url)}}"/>
@endsection

@section('header-code')
    {!! $headerCode->header_code ? $headerCode->header_code : '' !!}
@endsection

@section('content')


    <!--============= Start banner =============-->
    <section class="banner text-center">
        <div class="overlay">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12">
                        <div class="info">
                            <h2>{{--عن الدكتور محمد ابوزيد--}}{{__("trans.website_title")}}</h2>
                            <div class="navigation">
                                <ol class="breadcrumb">
                                    <li><a href="{{url('/')}}">{{--الرئيسية--}}{{__("trans.home")}}</a></li>
                                    <li><a href="{{url("/video")}}">{{--الأخبار--}}{{__("trans.video")}}</a></li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============ Start breadvroumb_area ============-->
    <div class="breadvroumb_area">
        <div class="container">
            <div class="row text-center">
                <div class="col">
                    <h1> {{--معرض الفيديو--}} {{__("trans.video_gallery")}}</h1>
                    <div class="breadcroumb_link">
                        <a href="{{url("/")}}">{{--الرئيسية--}} {{__("trans.home")}}</a>/  {{--الفيديو--}}{{__("trans.video")}}
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--============ End breadvroumb_area ============-->
    <!--============= Start about_page =============-->
    <div class="page-gallery" id="gallery">
        <div class="container py-4">
           {{-- <div class="row">
                <div class="col-lg-4 col-md-4 col-xs-6 thumb">
                    <div class="box-right">
                        <iframe width="100%" height="300" src="https://www.youtube.com/embed/p_oawstN_s8" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                    </div>
                </div>
                <div class="col-lg-4 col-md-4 col-xs-6 thumb">
                    <div class="box-right">
                        <iframe width="100%" height="300" src="https://www.youtube.com/embed/_oCV3kJIED0" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                    </div>
                </div>
                <div class="col-lg-4 col-md-4 col-xs-6 thumb">
                    <div class="box-right">
                        <iframe width="100%" height="300" src="https://www.youtube.com/embed/_Y6Ttq2l6zM" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                    </div>
                </div>
            </div>--}}
            <div class="row">
                @if($videos)
                    @foreach($videos[0]->videos as $video)
                    <div class="col-lg-4 col-md-4 col-xs-6 thumb">
                        <div class="box-right">
                            <iframe width="100%" height="300" src="{{$video->url}}" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                        </div>
                    </div>
                        @endforeach
                @else

                @endif

                {{--<div class="col-lg-4 col-md-4 col-xs-6 thumb">
                    <div class="box-right">
                        <iframe width="100%" height="300" src="https://www.youtube.com/embed/szqkX3IuJw8" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                    </div>
                </div>
                <div class="col-lg-4 col-md-4 col-xs-6 thumb">
                    <div class="box-right">
                        <iframe width="100%" height="300" src="https://www.youtube.com/embed/cL_DODf2gZI" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                    </div>
                </div>
                <div class="col-lg-4 col-md-4 col-xs-6 thumb">
                    <div class="box-right">
                        <iframe width="100%" height="300" src="https://www.youtube.com/embed/SMEB6tI4OFE" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                    </div>
                </div>--}}
            </div>
        </div>
    </div>

    <!--============ End about_page ============-->
@endsection
