<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

/*==============================================   Dashboard Routes    ====================================================*/

Route::group(['middleware' => 'auth' ,'namespace' => 'Dashboard'], function () {


    /* -- Return Home Page -- */
    Route::get('/mohamed-abuzaid-admin', 'DashboardController@index');

    /* -- Return Slider Page -- */
    Route::resource('/mohamed-abuzaid-admin/slider', 'SliderController');

    /* -- Return Service Page -- */
    Route::resource('/mohamed-abuzaid-admin/service', 'ServiceController');
    Route::get('/mohamed-abuzaid-admin/service/{id}/create', 'ServiceController@createSubService');
    Route::post('/mohamed-abuzaid-admin/sub-service/create', 'ServiceController@storeSub');
    Route::get('/mohamed-abuzaid-admin/service/{id}/show-images','ServiceController@showImages');
    Route::post("/mohamed-abuzaid-admin/service/show/{id}/deleteImage","ServiceController@destroyServiceImage");
    //Route::post("level-collection-admin/service/show/{id}/addImage","ServiceController@storeServiceImage");
    Route::post("/mohamed-abuzaid-admin/service/show/{id}/addImage","ServiceController@storeServiceImages");

    /* -- Return Client Page -- */
    Route::resource('/mohamed-abuzaid-admin/client', 'ClientController');

    /* -- Return Testimonial Page -- */
    Route::resource('/mohamed-abuzaid-admin/testimonial', 'TestimonialController');

    /* -- Return Team Page -- */
    Route::resource('/mohamed-abuzaid-admin/team', 'TeamController');

    /* -- Return Appointment Page -- */
    Route::resource('/mohamed-abuzaid-admin/appointment', 'AppointmentController');

    /* -- Return Video Page -- */
    Route::resource('/mohamed-abuzaid-admin/video', 'VideoController');

     /* -- Return Users Page -- */
    Route::resource('/mohamed-abuzaid-admin/users', 'UsersController');


   /* -- Return Blog Page -- */
    Route::resource('/mohamed-abuzaid-admin/blog', 'BlogController');

    /* -- Return Offer Page -- */
    Route::resource('/mohamed-abuzaid-admin/offer', 'OfferController');

    /* -- Return Album Page -- */
    Route::resource('/mohamed-abuzaid-admin/album', 'AlbumController');


      /* -- Return Working Days Page -- */
    Route::get('/mohamed-abuzaid-admin/working-days/edit', 'WorkingDaysController@edit');
    Route::patch('/mohamed-abuzaid-admin/working-days/update', 'WorkingDaysController@update');

    /* -- Return Gallery Page -- */
    Route::resource('/mohamed-abuzaid-admin/gallery', 'GalleryController');
    Route::get('/mohamed-abuzaid-admin/album/{id}/upload-to-gallery', 'AlbumController@uploadPage');
    Route::post('/mohamed-abuzaid-admin/album/{id}/upload-to-gallery', 'AlbumController@upload');
    Route::delete('/mohamed-abuzaid-admin/delete-image/{id}', 'AlbumController@deleteImageFromAlbum');

    /* -- Return Message Page -- */
    Route::resource('/mohamed-abuzaid-admin/message', 'MessageController');

    /*--------  About   --------*/
    Route::get('/mohamed-abuzaid-admin/about/edit', 'AboutController@edit');
    Route::patch('/mohamed-abuzaid-admin/about/update', 'AboutController@update');

    /*--------  Contact   --------*/
    Route::get('/mohamed-abuzaid-admin/contact/edit', 'ContactController@edit');
    Route::patch('/mohamed-abuzaid-admin/contact/update', 'ContactController@update');


    /*--------  Setting   --------*/
    Route::get('/mohamed-abuzaid-admin/setting/edit', 'SettingController@edit');
    Route::patch('/mohamed-abuzaid-admin/setting/update', 'SettingController@update');

    /* -- Return Blog Page -- */
    Route::resource('/mohamed-abuzaid-admin/feature', 'FeatureController');

    /* -- Return branch Page -- */
    Route::resource('/mohamed-abuzaid-admin/branch', 'BranchController');
    Route::patch('/mohamed-abuzaid-admin/branch/update', 'BranchController@update');
    
     /* -- Return FAQ Page -- */
    Route::resource('mohamed-abuzaid-admin/faq', 'FaqController');




    /*=================================================================================================================*/
    /*----------------------------------------------  Seo   -----------------------------------------------------------*/
    /*=================================================================================================================*/
    /*--------  website Main Pages   --------*/
    Route::get('/mohamed-abuzaid-admin/seo/website-pages', 'SeoController@websitePages');
    Route::get('/mohamed-abuzaid-admin/seo/website-page/edit/{id}', 'SeoController@editWebsitePage');
    Route::patch('/mohamed-abuzaid-admin/seo/website-page/edit/{id}', 'SeoController@updateWebsitePage');
    /*--------  website Open Graphs   --------*/
    Route::get('/mohamed-abuzaid-admin/seo/open-graph', 'SeoController@openGraph'); /*--------  edit main pages open graph   --------*/
    Route::get('/mohamed-abuzaid-admin/seo/main-pages-open-graph/edit/{id}', 'SeoController@editMainPageOpenGraph');
    Route::patch('/mohamed-abuzaid-admin/seo/main-pages-open-graph/edit/{id}', 'SeoController@updateMainPageOpenGraph');
    /*--------  clinics pages open graph   --------*/
    Route::get('/mohamed-abuzaid-admin/seo/services-pages-open-graph/edit/{id}', 'SeoController@editServicePagesOpenGraph');
    /*--------  articles pages open graph   --------*/
    Route::get('/mohamed-abuzaid-admin/seo/articles-pages-open-graph/edit/{id}', 'SeoController@editArticlesPagesOpenGraph');
    /*--------  clinics pages open graph   --------*/
    Route::get('/mohamed-abuzaid-admin/seo/edit-open-graph/{id}', 'SeoController@editOpenGraph');
    /*--------  website Main Pages   --------*/
    /*-------- sameAs   --------*/
    Route::get('/mohamed-abuzaid-admin/seo/same-as', 'SeoController@sameAs');
    Route::get('/mohamed-abuzaid-admin/seo/create-same-as', 'SeoController@createSameAs');
    Route::post('/mohamed-abuzaid-admin/seo/create-same-as/create', 'SeoController@storeSameAs');
    Route::get('/mohamed-abuzaid-admin/seo/edit-same-as/edit/{id}', 'SeoController@editSameAs');
    Route::patch('/mohamed-abuzaid-admin/seo/edit-same-as/edit/{id}', 'SeoController@updateSameAs');
    Route::delete('/mohamed-abuzaid-admin/seo/delete-same-as/{id}', 'SeoController@deleteSameAs');
    /*-------- Forms   --------*/
    Route::get('/mohamed-abuzaid-admin/seo/form', 'SeoController@form');
    Route::get('/mohamed-abuzaid-admin/seo/form/edit/{id}', 'SeoController@editForm');
    Route::patch('/mohamed-abuzaid-admin/seo/form/edit/{id}', 'SeoController@updateForm');


});




Auth::routes();

Auth::routes();

Route::get('/home', 'HomeController@index')->name('home');
