<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


Route::get('/', function () {
    return view('welcome');
});




Route::get('/services', function () {
    return view('website.all_services');
});


Route::group(['middleware' => ['Maintenance', 'Lang']], function () {

    Route::get('lang/{lang}', 'LanguageController@changeLanguage');

    /*=======   Return Home     ========*/
    Route::get('/', 'WebsitePagesController@index');

    /*=======   Return about    ========*/
    Route::get('/about', 'WebsitePagesController@about');
    Route::get('/team', 'WebsitePagesController@team');
    Route::get('/bio', 'WebsitePagesController@bio');

    /*=======   Return gallery  ========*/
    Route::get('/gallery', 'WebsitePagesController@gallery');

    /*=======   Return Service    ========*/
    Route::get('/service', 'WebsitePagesController@service');

    /*=======   Return Blog    ========*/
    /*=======   Return Blog    ========*/
    Route::get('/blog', 'WebsitePagesController@blog');
    Route::get('/blog/{url}', 'WebsitePagesController@blogDetails');

    /*=======   Return Blog    ========*/
    Route::get('/offers', 'WebsitePagesController@offers');

    /*=======   Return Album    ========*/
    Route::get('/album', 'WebsitePagesController@album');
    Route::get('/album/{id}', 'WebsitePagesController@albumDetails');

    /*=======   Return Service Details     ========*/
    Route::get('/serviceDetails/{id}', 'WebsitePagesController@serviceDetails');

    /*=======   Return Contact     ========*/
   /* Route::get('/contact', 'WebsitePagesController@contact');
    Route::post('message', 'WebsitePagesController@message');*/


    /*=======   Reserve   ========*/
    Route::get('/reserve', 'WebsitePagesController@reserve');
    Route::post('/reserve', 'WebsitePagesController@reserveAppointment');


    /*=======   Return Service    ========*/
    
    //Route::get('/service', 'WebsitePagesController@service');


    /*=======   Return Service Details     ========*/
    Route::get('/service/{url}', 'WebsitePagesController@serviceDetails');

    /*=======   Return success stories     ========*/
    Route::get('/success-story', 'WebsitePagesController@all_success_story');
    Route::get('/success-story/{url}', 'WebsitePagesController@success_story');

    /*=======   Return contact(branchs) stories     ========*/
    Route::get('/medical-tourism', 'WebsitePagesController@all_medical_tourism');
    Route::get('/medical-tourism/{url}', 'WebsitePagesController@medical_tourism');

    /*=======   Return contact stories     ========*/
    Route::get('/contact', 'WebsitePagesController@branch');

    /*=======   Return video      ========*/
    Route::get('/video', 'WebsitePagesController@video');
    
    /*=======   Return questions  ========*/
    Route::get('/questions', 'WebsitePagesController@question');



});


Route::get('maintenance', function () {
    return 'maintenance';
});


Auth::routes();

Auth::routes();

Route::get('/home', 'HomeController@index')->name('home');
