<?php $__env->startSection('title', 'Dashboard'); ?>
<!-- Drop Your Customized Style Here -->
<?php $__env->startSection('customizedStyle'); ?>
<?php $__env->stopSection(); ?>
<!-- Drop Your Customized Scripts Here -->
<?php $__env->startSection('customizedScript'); ?>
<?php $__env->stopSection(); ?>
<!-- Start of content section -->
<?php $__env->startSection('content'); ?>


    <section class="content-header">
        <h1>
            Album
            <small>Show Album Images</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo e(adminUrl('/')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo e(adminUrl('/album')); ?>">Album</a></li>
            <li class="active">Update Album</li>
        </ol>
    </section>

    <section class="content container-fluid">
        <?php echo $__env->make('dashboard.layouts.messages', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        <div class="images-wrapper">
            <ul>
                <?php if($albumImages): ?>
                    <?php $__currentLoopData = $albumImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li>
                            <div class="remove-btn modal-btn" data-toggle="modal" data-target="#delete<?php echo e($image->id); ?>">
                                <i class="ion-ios-close-empty"></i>
                            </div>
                            <img src="<?php echo e(assetPath($image->path)); ?>" alt="clinic-image">
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </ul>
        </div>

        <?php if($albumImages): ?>
            <?php $__currentLoopData = $albumImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="modal modal-danger fade" id="delete<?php echo e($image->id); ?>">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title">Delete Image</h4>
                            </div>
                            <div class="modal-body">
                                <p>Are You Sure You Want To Delete Image</p>
                            </div>
                            <div class="modal-footer">
                                <form action="<?php echo e(adminUrl('delete-image/'.$image->id)); ?>" method="post">
                                    <?php echo method_field('delete'); ?>
                                    <?php echo csrf_field(); ?>
                                    <div class="d-flex flex-row">
                                        <button type="button" class="btn btn-outline-danger" data-dismiss="modal" style="margin-right: 5px">
                                            cancel
                                        </button>
                                        <button type="submit" class="btn btn-danger">
                                            Delete
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <!-- /.modal-content -->
                    </div>
                    <!-- /.modal-dialog -->
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
    </section>

<?php $__env->stopSection(); ?>





<?php echo $__env->make('dashboard.layouts.layouts', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>