<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('customizedStyle'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('customizedScript'); ?>
    <script>
        $(function () {
            $('#example1').DataTable()
            $('#example2').DataTable({
                'paging'      : true,
                'lengthChange': false,
                'searching'   : false,
                'ordering'    : true,
                'info'        : true,
                'autoWidth'   : false
            })
        })
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <section class="content-header">
        <h1>
            Service Images
            <small>All  <?php echo e($service->service_en->title); ?> Images</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo e(adminUrl("")); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo e(adminUrl("/service")); ?>">Service</a></li>
            <li class="active">All Service Images</li>
        </ol>
    </section>


    <section class="content">
        <div class="row">
            <!-- left column -->
            <div class="col-md-12">
                <div class="box box-primary" style="padding: 15px">
                    <div class="box-header with-border">
                        <h3 class="box-title">All Images For  <?php echo e($service->service_en->title); ?> Service</h3>
                        <a href="#" class="btn btn-warning pull-right remove-btn modal-btn" data-toggle="modal" data-target="#add5">
                            <i class="fa fa-plus"></i> Add New Image </a>
                    </div>
                <?php echo $__env->make('dashboard.layouts.messages', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                <!-- /.box-header -->
                    <!-- form start -->
                    <div class="images-wrapper">
                        <ul>
                            <?php if($service): ?>

                                <?php if($service->images): ?>
                                <?php $count=0 ?>
                                <?php $__currentLoopData = $service->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service_image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li>
                                        <div class="remove-btn modal-btn" data-toggle="modal" data-target="#delete<?php echo e($count); ?>">
                                            <i class="ion-ios-close-empty"></i>
                                        </div>
                                        <img src="<?php echo e(assetPath($service_image->path)); ?>" alt="img">
                                    </li>
                                    <?php $count++ ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                <?php endif; ?>
                            <?php else: ?>

                            <?php endif; ?>

                        </ul>
                    </div>

                    <?php if($service->images): ?>
                        <?php $count=0 ?>
                        <?php $__currentLoopData = $service->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service_image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="modal modal-danger fade" id="delete<?php echo e($count); ?>">

                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span></button>
                                    <h4 class="modal-title">Delete User</h4>
                                </div>
                                <div class="modal-body">
                                    <p>Are You Sure You Want To Delete This Image of <strong><?php echo e($service->id); ?></strong></p>
                                </div>
                                <div class="modal-footer">
                                    <form action="<?php echo e(adminUrl("service")); ?>/show/<?php echo e($service->id); ?>/deleteImage" method="post">

                                        <?php echo csrf_field(); ?>
                                        <input type="hidden"name="image"value="<?php echo e($service_image->name); ?>">
                                        <input type="hidden"name="image_id"value="<?php echo e($service_image->id); ?>">
                                        <div class="d-flex flex-row">
                                            <button type="button" class="btn btn-outline-danger" data-dismiss="modal" style="margin-right: 5px">
                                                cancel
                                            </button>
                                            <button type="submit" class="btn btn-danger">
                                                Delete
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <!-- /.modal-content -->
                        </div>
                        <!-- /.modal-dialog -->
                    </div>
                    <!-- /.modal -->
                            <?php $count++ ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>

                    <?php endif; ?>

                    <!-- /.modal -->
                    <!--- modal for add image(s) -->
                    <div class="modal modal-danger fade" id="add5">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span></button>
                                    <h4 class="modal-title">Add User</h4>
                                </div>
                                <div class="modal-body">
                                    <p>Are You Sure You Want To Add This Image For <strong><?php echo e($service->id); ?></strong></p>
                                </div>
                                <div class="modal-footer">
                                    <form action="<?php echo e(adminUrl("service").'/show/'.$service->id.'/addImage'); ?>" method="post"enctype="multipart/form-data">

                                        <?php echo csrf_field(); ?>
                                        
                                        <input type="file" class="form-control" name="service_image[]" value=""multiple>
                                        <div class="d-flex flex-row">
                                            <button type="button" class="btn btn-outline-danger" data-dismiss="modal" style="margin-right: 5px">
                                                cancel
                                            </button>
                                            <button type="submit" class="btn btn-danger">
                                                Ok
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <!-- /.modal-content -->
                        </div>
                        <!-- /.modal-dialog -->
                    </div>
                    <!-- /.modal -->

                    


                </div>
            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.layouts.layouts', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>