<?php $__env->startSection('title', __('trans.common_questions')); ?>

<?php $__env->startSection('open-graph'); ?>
    <meta name="description" content="<?php echo e($og->description ? $og->description : $mainOpenGraph->description); ?>">
    <meta name="keywords" content="<?php echo e($og->key_words ? $og->key_words : $mainOpenGraph->key_words); ?>">
    <!-- open graph meta-->
    <meta property="og:title" content="<?php echo e($og->open_graph->og_title ? $og->open_graph->og_title : $mainOpenGraph->open_graph->og_title); ?>"/>
    <meta property="og:type" content="<?php echo e($og->open_graph->og_type ? $og->open_graph->og_type : $mainOpenGraph->open_graph->og_type); ?>"/>
    <meta property="og:url" content="<?php echo e(url($og->url)); ?>"/>
    <meta property="og:image" content="
    <?php if($og->open_graph->image_url): ?>
    <?php echo e($og->open_graph->image_url); ?>

    <?php elseif($og->open_graph->open_graph_image): ?>
    <?php echo e(asset($og->open_graph->open_graph_image->path)); ?>

    <?php else: ?>
    <?php echo e($mainOpenGraph->open_graph->image_url); ?>

    <?php endif; ?>
    "
    />
    <meta property="og:description" content="<?php echo e($og->open_graph->og_description ? $og->open_graph->og_description : $mainOpenGraph->open_graph->og_description); ?>"/>
    <meta property="og:site_name" content="<?php echo e($og->open_graph->og_site_name ? $og->open_graph->og_site_name : $mainOpenGraph->open_graph->og_site_name); ?>"/>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('canonical'); ?>
    <link rel="canonical" href="<?php echo e(url($og->url)); ?>"/>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header-code'); ?>
    <?php echo $headerCode->header_code ? $headerCode->header_code : ''; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <!--============= Start banner =============-->
    <section class="banner text-center">
        <div class="overlay">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12">
                        <div class="info">
                            <h2><?php echo e(__("trans.website_title")); ?></h2>
                            <div class="navigation">
                                <ol class="breadcrumb">
                                    <li><a href="<?php echo e(url("/")); ?>"><?php echo e(__("trans.home")); ?></a></li>
                                    <li><a href="<?php echo e(url("/questions")); ?>"><?php echo e(__("trans.faq")); ?></a></li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============= End banner =============-->

    <!--============= Start FAq =============-->
    <section class="faq-content-area">
        <div class="container">
            <div class="row">

                <div class="col-lg-12 col-md-12 col-sm-12">
                    <div class="single-box">
                        <div class="sec-title mar0auto text-center">
                            <h1>اهم الاسئلة الشائعة</h1>
                            <span class="border"></span>
                        </div>
                        <div class="accordion-box">
                             <?php if($faqs): ?>
                                <?php $__currentLoopData = $faqs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $faq): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="accordion accordion-block">
                                        <div class="accord-btn <?php echo e($loop->first ? 'active' :''); ?>">
                                            <h4><?php echo e($faq->{'faq_'.currentLang()}->question); ?></h4>
                                        </div>
                                        <div class="accord-content" style="<?php echo e($loop->first ? 'display: block;' :'display: none;'); ?>">
                                            <p><?php echo e($faq->{'faq_'.currentLang()}->answer); ?></p>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                            
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </section>
    <!--============= End FAq =============-->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('website.layouts.layouts', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>