<?php $__env->startSection('title', __('trans.contact')); ?>

<?php $__env->startSection('open-graph'); ?>
    <meta name="description" content="<?php echo e($og->description ? $og->description : $mainOpenGraph->description); ?>">
    <meta name="keywords" content="<?php echo e($og->key_words ? $og->key_words : $mainOpenGraph->key_words); ?>">
    <!-- open graph meta-->
    <meta property="og:title" content="<?php echo e($og->open_graph->og_title ? $og->open_graph->og_title : $mainOpenGraph->open_graph->og_title); ?>"/>
    <meta property="og:type" content="<?php echo e($og->open_graph->og_type ? $og->open_graph->og_type : $mainOpenGraph->open_graph->og_type); ?>"/>
    <meta property="og:url" content="<?php echo e(url($og->url)); ?>"/>
    <meta property="og:image" content="
    <?php if($og->open_graph->image_url): ?>
    <?php echo e($og->open_graph->image_url); ?>

    <?php elseif($og->open_graph->open_graph_image): ?>
    <?php echo e(asset($og->open_graph->open_graph_image->path)); ?>

    <?php else: ?>
    <?php echo e($mainOpenGraph->open_graph->image_url); ?>

    <?php endif; ?>
    "
    />
    <meta property="og:description" content="<?php echo e($og->open_graph->og_description ? $og->open_graph->og_description : $mainOpenGraph->open_graph->og_description); ?>"/>
    <meta property="og:site_name" content="<?php echo e($og->open_graph->og_site_name ? $og->open_graph->og_site_name : $mainOpenGraph->open_graph->og_site_name); ?>"/>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('canonical'); ?>
    <link rel="canonical" href="<?php echo e(url($og->url)); ?>"/>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header-code'); ?>
    <?php echo $headerCode->header_code ? $headerCode->header_code : ''; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>


    <!--============= Start banner =============-->
    <section class="banner text-center">
        <div class="overlay">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12">
                        <div class="info">
                            <h2><?php echo e(__("trans.website_title")); ?></h2>
                            <div class="navigation">
                                <ol class="breadcrumb">
                                    <li><a href="<?php echo e(url("/")); ?>"><?php echo e(__("trans.home")); ?></a></li>
                                    <li><a href="<?php echo e(url("/contact")); ?>"><?php echo e(__("trans.contact")); ?></a></li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============= End banner =============-->
    <!--============ start contact ============-->
    <div class="contact_page">
        <div class="container">

            <div class="row">
                <?php if($branchs): ?>
                    <?php $__currentLoopData = $branchs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-lg-6 col-md-6 col-sm-12">
                            <div class="map">
                                <iframe src="<?php echo e($branch->location); ?>" width="100%" height="450" frameborder="0" style="border:0;" allowfullscreen=""></iframe>
                            </div>

                            <div class="contact_widget">
                                <h4><?php echo e($branch->{'branch_'.currentLang()}->name); ?></h4>
                                <ul class="widget_menu">

                                    <li><i class="fas fa-map-marker-alt"></i><span><?php echo e($branch->{'branch_'.currentLang()}->address); ?></span></li>
                                    <li><i class="fas fa-phone"></i><span> <?php echo e($branch->phone); ?></span></li>
                                </ul>

                            </div>

                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <?php else: ?>
                    <div class="col-lg-6 col-md-6 col-sm-12">
                        <div class="map">
                            <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3451.9881371883316!2d31.327343815116194!3d30.094526081864093!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x1458158b1e7c5a65%3A0x6444fef7b88e7a8c!2z2LnZitin2K_ZhyDYp9ivINmF2K3ZhdivINmF2K3ZhdmI2K8g2KfYqNmI2LLZitivINmE2KzYsdin2K3Yp9iqINin2YTYs9mF2YbZhyDZiCDYqtmD2YXZitmFINin2YTZhdi52K_YqSAtIFBlcmZlY3QgSGVhbHRoIENsaW5pY3M!5e0!3m2!1sen!2seg!4v1568106265915!5m2!1sen!2seg" width="100%" height="450" frameborder="0" style="border:0;" allowfullscreen=""></iframe>
                        </div>

                        <div class="contact_widget">
                            <h4>عيادة مصر الجديدة</h4>
                            <ul class="widget_menu">

                                <li><i class="fas fa-map-marker-alt"></i><span>  40 ش كليوباترا , ميدان صلاح الدين
مصر الجديدة, القاهرة -  </span></li>
                                <li><i class="fas fa-phone"></i><span> 01118847052</span></li>
                            </ul>

                        </div>

                    </div>
                    <div class="col-lg-6 col-md-6 col-sm-12">
                        <div class="contact_widget">
                            <h4>عيادة التجمع الخامس</h4>
                            <ul class="widget_menu">

                                <li><i class="fas fa-map-marker-alt"></i><span>   التجمع الخامس   </span></li>
                                <li><i class="fas fa-phone"></i><span> 01023370079</span></li>
                            </ul>

                        </div>

                        <div class="map">
                            <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3454.598225993528!2d31.433937015114434!3d30.01969088189126!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x1458413b462b7f49%3A0x8753eee2bf00b4dc!2z2LnZitin2K_ZhyDYp9ivINmF2K3ZhdivINmF2K3ZhdmI2K8g2KfYqNmI2LLZitivINmE2KzYsdin2K3Yp9iqINin2YTYs9mF2YbZhyDZiCDYqtmD2YXZitmFINin2YTZhdi52K_YqSAtIFBlcmZlY3QgSGVhbHRoIENsaW5pY3M!5e0!3m2!1sen!2seg!4v1568106294670!5m2!1sen!2seg" width="100%" height="450" frameborder="0" style="border:0;" allowfullscreen=""></iframe>
                        </div>

                    </div>
                <?php endif; ?>

            </div>
        </div>
    </div>
    <!--============ End contact ============-->


<?php $__env->stopSection(); ?>

<?php echo $__env->make('website.layouts.layouts', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>