<?php $__env->startSection('title', __('trans.team')); ?>

<?php $__env->startSection('open-graph'); ?>
    <meta name="description" content="<?php echo e($og->description ? $og->description : $mainOpenGraph->description); ?>">
    <meta name="keywords" content="<?php echo e($og->key_words ? $og->key_words : $mainOpenGraph->key_words); ?>">
    <!-- open graph meta-->
    <meta property="og:title" content="<?php echo e($og->open_graph->og_title ? $og->open_graph->og_title : $mainOpenGraph->open_graph->og_title); ?>"/>
    <meta property="og:type" content="<?php echo e($og->open_graph->og_type ? $og->open_graph->og_type : $mainOpenGraph->open_graph->og_type); ?>"/>
    <meta property="og:url" content="<?php echo e(url($og->url)); ?>"/>
    <meta property="og:image" content="
    <?php if($og->open_graph->image_url): ?>
    <?php echo e($og->open_graph->image_url); ?>

    <?php elseif($og->open_graph->open_graph_image): ?>
    <?php echo e(asset($og->open_graph->open_graph_image->path)); ?>

    <?php else: ?>
    <?php echo e($mainOpenGraph->open_graph->image_url); ?>

    <?php endif; ?>
    "
    />
    <meta property="og:description" content="<?php echo e($og->open_graph->og_description ? $og->open_graph->og_description : $mainOpenGraph->open_graph->og_description); ?>"/>
    <meta property="og:site_name" content="<?php echo e($og->open_graph->og_site_name ? $og->open_graph->og_site_name : $mainOpenGraph->open_graph->og_site_name); ?>"/>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('canonical'); ?>
    <link rel="canonical" href="<?php echo e(url($og->url)); ?>"/>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header-code'); ?>
    <?php echo $headerCode->header_code ? $headerCode->header_code : ''; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>


    <!--============= Start banner =============-->
    <section class="banner text-center">
        <div class="overlay">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12">
                        <div class="info">
                            <h2><?php echo e(__("trans.website_title")); ?></h2>
                            <div class="navigation">
                                <ol class="breadcrumb">
                                    <li><a href="<?php echo e(url("/")); ?>"><?php echo e(__("trans.home")); ?></a></li>
                                    <li><a href="<?php echo e(url("/team")); ?>"><?php echo e(__("trans.team")); ?></a></li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============= End banner =============-->
    <!--============= Start main_info =============-->
    <section class="main_info">
        <div class="container">

            <div class="row">
                <div class="col-md-8 col-sm-12">
                    <div class="head_info">
                        <h3 class="wow fadeInRight" data-wow-duration="1.5s">
                            
                            <?php echo e(__("trans.dr_abouzeid_team")); ?>

                            <hr>
                        </h3>
                        
                        <?php echo $about?str_limit($about->{'about_'.currentLang()}->value,600,'...') :'no data to show.'; ?>

                    </div>
                </div>
                <div class="col-md-4 col-sm-12">
                    <div class="img-box">
                        <?php if($about): ?>
                            <img src="<?php echo e(assetPath($about->aboutImage->path)); ?>" alt="" style="width: 100%">
                            <?php else: ?>
                            <img src="imgs/dr-about.JPG" alt="" style="width: 100%">
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============= end main_info =============-->

    <!--============= Start cheif =============-->
    <section class="cheif">
        <div class="overlay">
            <div class="container">
                <?php if($members): ?>
                    <?php $__currentLoopData = $members; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="block">
                            <div class="head">
                                <h3><?php echo e($member->{'team_'.currentLang()}->job_title); ?></h3>
                            </div>
                            <div class="row">

                                <div class="col-md-4 col-xs-12">
                                    <div class="img_body">
                                        <img src="<?php echo e(assetPath($member->image->path)); ?>" alt="">
                                        <h3><?php echo e($member->{'team_'.currentLang()}->name); ?></h3>
                                        <ul class="list-unstyled list-inline">
                                            <li>
                                                <a href=""><i class="fa fa-facebook fa-fw"></i></a>
                                            </li>
                                            <li>
                                                <a href=""><i class="fa fa-twitter fa-fw"></i></a>
                                            </li>
                                            <li>
                                                <a href="" ><i class="fa fa-youtube fa-fw"></i></a>
                                            </li>
                                            <li>
                                                <a href="" ><i class="fa fa-instagram fa-fw"></i></a>
                                            </li>
                                            <li>
                                                <a href=""><i class="fab fa-snapchat-ghost" aria-hidden="true"></i></a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>


                                <div class="col-md-8 col-xs-12">
                                    <p>
                                        <?php echo e($member->{'team_'.currentLang()}->description); ?>

                                    </p>
                                </div>

                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>

                <?php endif; ?>
                
            </div>
        </div>
    </section>
    <!--============= End cheif =============-->
    <!--============= Start contact_bar =============-->
    <section class="contact_bar">
        <div class="overlay">
            <div class="container">
                <h3><?php echo e(__("trans.page_end_description")); ?></h3>
            </div>
        </div>
    </section>
    <!--============= End contact_bar =============-->


<?php $__env->stopSection(); ?>

<?php echo $__env->make('website.layouts.layouts', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>