<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('customizedStyle'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('customizedScript'); ?>
    <script>
        //Initialize Select2 Elements
        $('.select2').select2()
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <section class="content-header">
        <h1>
            Video
            <small>Add New Video</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo e(adminUrl('/')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo e(adminUrl('/video')); ?>">Gallery</a></li>
            <li class="active">Add New Video</li>
        </ol>
    </section>


    <section class="content">
        <?php echo $__env->make('dashboard.layouts.messages', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        <form role="form" action="<?php echo e(route('video.update', $video->id)); ?>" enctype="multipart/form-data" method="post">
            <?php echo csrf_field(); ?>
            <?php echo method_field('patch'); ?>
            <input type="hidden" name="created_by">
            <div class="row">
                <!-- English Side -->
                <div class="col-md-6">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Add Video URL</h3>
                        </div>
                        <!-- /.box-header -->
                        <!-- form start -->
                        <div class="box-body">
                            <div class="form-group">

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1"> Video Url</label>
                                    <input type="url" class="form-control" name="url" multiple id="exampleInputEmail1" placeholder="Enter Video Url" value="<?php echo e($video->url); ?>">
                                    <p class="help-block"> Enter Embed url </p>
                                </div>

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1"> Album Name</label>
                                    <select name="album_id" id="admin_type" class="form-control">
                                        <option value="0">Choose Album Name</option>
                                        <?php if($albums): ?>
                                            <?php $__currentLoopData = $albums; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $album): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($album->id); ?>" <?php echo e($album->id == $video->album_id ? 'selected' : ''); ?>><?php echo e($album->album_en->title); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </select>
                                    <p class="help-block"> Choose album for this video</p>
                                </div>
                            </div>
                        </div>
                        <div class="box-footer">
                            <div class="col-lg-12">
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Arabic Side -->
            </div>
        </form>
    </section>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.layouts.layouts', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>