<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('customizedStyle'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('customizedScript'); ?>
    <script src="<?php echo e(assetPath('dashboard/bower_components/ckeditor/ckeditor.js')); ?>"></script>
    <script>
        //Initialize Select2 Elements
        //$('.select2').select2()
        $(function () {
            // Replace the <textarea id="editor1"> with a CKEditor
            // instance, using default configuration.
            CKEDITOR.replace('editor1');
            CKEDITOR.replace('editor2');
            CKEDITOR.replace('editor3');
            CKEDITOR.replace('editor4');
            CKEDITOR.replace('editor5');
            CKEDITOR.replace('editor6');
            CKEDITOR.replace('editor7');
            CKEDITOR.replace('editor8');
            //bootstrap WYSIHTML5 - text editor
        });

    </script>
    <script>
        //Initialize Select2 Elements
        $('.select2').select2()
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <section class="content-header">
        <h1>
            Services
            <small>Edit Service</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo e(adminUrl('/')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo e(adminUrl('/service')); ?>">Service</a></li>
            <li class="active">Edit Service</li>
        </ol>
    </section>


    <section class="content">
        <?php echo $__env->make('dashboard.layouts.messages', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        <form role="form" action="<?php echo e(route('service.update', $service->id)); ?>" enctype="multipart/form-data" method="post">
            <?php echo csrf_field(); ?>
            <?php echo method_field('patch'); ?>
            <div class="row">
                <!-- English Side -->
                <div class="col-md-6">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Add Service Info</h3>
                        </div>
                        <!-- /.box-header -->
                        <!-- form start -->
                        <div class="box-body">
                            <div class="form-group">

                                <?php if($service->parent_service_id): ?>
                                    <div class="col-lg-12">
                                        <label for="exampleInputEmail1"> Main Service</label>
                                        <input type="text" class="form-control" disabled="disabled" name="main_service" id="exampleInputEmail1" placeholder="Enter Service Title" value="<?php echo e($service->parentService->service_en->title); ?>">
                                        <p class="help-block">This is The Parent service of the one you will add</p>
                                    </div>
                                <?php endif; ?>

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1"> Title</label>
                                    <input type="text" class="form-control" name="title_en" id="exampleInputEmail1" placeholder="Enter Service Title" value="<?php echo e($service->service_en->title); ?>">
                                    <p class="help-block">Enter title of service</p>
                                </div>

                               

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1">Service Url</label>
                                    <input type="text" class="form-control" name="url" id="exampleInputEmail1" placeholder="Enter Service Url" value="<?php echo e($service->url); ?>">
                                    <p class="help-block">Enter Url of Article which will shown in url <strong>If Url is empty, system will choose article title as url by Default</strong></p>
                                </div>

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1"> Service Description</label>
                                    <textarea class="form-control" name="description_en" id="editor1" placeholder="Enter Service Description" rows="6"><?php echo e($service->service_en->description); ?></textarea>
                                    <p class="help-block">Enter Description of Service</p>
                                </div>

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1"> Image</label>
                                    <input type="file" class="form-control" name="image_id" id="exampleInputEmail1" placeholder="Enter Service text">
                                    <p class="help-block"> Upload Service Image </p>
                                </div>

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1">Image Alt Text</label>
                                    <input type="text" class="form-control" name="img_alt" id="exampleInputEmail1" placeholder="Enter Alt Text" value="<?php echo e($service->image->alt); ?>">
                                    <p class="help-block"> Enter Alt Text for Image to show it if image isn't loaded </p>
                                </div>

                                


                            </div>
                        </div>
                        <div class="box-footer">
                            <div class="col-lg-12">
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Arabic Side -->
                <div class="col-md-6 arab_dir">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">أضف بيانات الصورة</h3>
                        </div>
                        <!-- .box-header -->
                        <!-- form start -->
                        <div class="box-body">
                            <div class="form-group">

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1"> عنوان الخدمة</label>
                                    <input type="text" class="form-control" name="title_ar" id="exampleInputEmail1" placeholder="ادخل عنوان الخدمة" value="<?php echo e($service->service_ar->title); ?>">
                                    <p class="help-block">أضف عنوان الخدمة</p>
                                </div>

                                

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1">وصف الخدمة</label>
                                    <textarea class="form-control" name="description_ar" id="editor2" placeholder="ادخل  وصف الخدمة" rows="6"><?php echo e($service->service_ar->description); ?></textarea>
                                    <p class="help-block">ادخل وصفا دقيقا عن الخدمة</p>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </section>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.layouts.layouts', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>