<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('customizedStyle'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('customizedScript'); ?>
    <script>
        $(function () {
            $('#example1').DataTable()
            $('#example2').DataTable({
                'paging'      : true,
                'lengthChange': true,
                'searching'   : true,
                'ordering'    : true,
                'info'        : true,
                'autoWidth'   : false
            })
        })
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <section class="content-header">
        <h1>
            Main Pages Open Graphs
            <small>All Main Pages Open Graphs</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo e(adminUrl('/')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo e(adminUrl('/seo/main-pages-open-graph')); ?>"> Main Pages Open Graphs</a></li>
            <li class="active">All main-pages-open-graph</li>
        </ol>
    </section>



    <section class="content">
        <div class="row">
            <!-- left column -->
            <div class="col-md-12">
                <div class="box box-primary" style="padding: 15px">
                    <div class="box-header with-border">
                        <h3 class="box-title">All main-pages-open-graph Info</h3>
                    </div>
                <?php echo $__env->make('dashboard.layouts.messages', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                <!-- /.box-header -->
                    <!-- form start -->
                    <table id="example2" class="table table-bordered table-hover">
                        <thead>
                        <tr>
                            <th>id</th>
                            <th>og:image</th>
                            <th>og:url</th>
                            <th>og:title</th>
                            <th>Created at</th>
                            <th>Updated at</th>
                            <th>Actions</th>
                        </tr>
                        </thead>
                        <tfoot>
                        <tr>
                            <th>id</th>
                            <th>og:image</th>
                            <th>og:url</th>
                            <th>og:title</th>
                            <th>Created at</th>
                            <th>Updated at</th>
                            <th>Actions</th>
                        </tr>
                        </tfoot>
                        <tbody>
                        <?php if($mainPages): ?>
                            <?php $__currentLoopData = $mainPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($page->id); ?></td>
                                    
                                    <td><img src="<?php echo e($page->open_graph->image_url !== null ? $page->open_graph->image_url  : assetPath($page->open_graph->open_graph_image->path)); ?>" style="width: 50px" alt="og_image" > </td>
                                    <td><?php echo e($page->open_graph->og_url); ?></td>
                                    <td><?php echo e($page->open_graph->og_title); ?></td>
                                    <td><?php echo e($page->open_graph->created_at->diffForHumans()); ?></td>
                                    <td><?php echo e($page->open_graph->updated_at->diffForHumans()); ?></td>
                                    <td>
                                        <a href="<?php echo e(adminUrl('seo/main-pages-open-graph/edit/'.$page->id)); ?>" class style="font-size: 20px"><i class="fa fa-pencil-square-o"></i> </a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>


                        </tbody>
                    </table>

                </div>
            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.layouts.layouts', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>