<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('customizedStyle'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('customizedScript'); ?>
    <script>
        //Initialize Select2 Elements
        $('.select2').select2()
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <section class="content-header">
        <h1>
            Testimonial
            <small>Add New Testimonial</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo e(adminUrl('/')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo e(adminUrl('/testimonial')); ?>">Testimonial</a></li>
            <li class="active">Add Testimonial</li>
        </ol>
    </section>


    <section class="content">
        <?php echo $__env->make('dashboard.layouts.messages', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        <form role="form" action="<?php echo e(route('testimonial.update', $testimonial->id)); ?>" enctype="multipart/form-data" method="post">
            <?php echo csrf_field(); ?>
            <?php echo method_field('patch'); ?>
            <div class="row">
                <!-- English Side -->
                <div class="col-md-6">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Edit Testimonial Info</h3>
                        </div>
                        <!-- /.box-header -->
                        <!-- form start -->
                        <div class="box-body">
                            <div class="form-group">

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1">Client Name</label>
                                    <input type="text" class="form-control" name="username_en" id="exampleInputEmail1" placeholder="Enter Client Name" value="<?php echo e($testimonial->testimonial_en->username); ?>">
                                    <p class="help-block">Enter Username of Testimonial</p>
                                </div>

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1">Text of Testimonial</label>
                                    <textarea type="text" class="form-control" name="text_en" id="editor1" placeholder="Enter Text of Testimonial" rows="6"><?php echo e($testimonial->testimonial_en->text); ?></textarea>
                                    <p class="help-block">Text of Testimonial</p>
                                </div>

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1"> Image</label>
                                    <input type="file" class="form-control" name="image_id" id="exampleInputEmail1" placeholder="Enter button text">
                                    <p class="help-block"> Upload Testimonial </p>
                                </div>
                            </div>
                        </div>
                        <div class="box-footer">
                            <div class="col-lg-12">
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Arabic Side -->
                <div class="col-md-6 arab_dir">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">أضف التوصيات</h3>
                        </div>
                        <!-- .box-header -->
                        <!-- form start -->
                        <div class="box-body">
                            <div class="form-group">
                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1">اسم صاحب التوصية</label>
                                    <input type="text" class="form-control" name="username_ar" id="exampleInputEmail1" placeholder="ادخل اسم صاحب التوصية" value="<?php echo e($testimonial->testimonial_ar->username); ?>">
                                    <p class="help-block">ادخل اسم المستخدم صاحب التوصية</p>
                                </div>

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1">نص التوصية</label>
                                    <textarea type="text" class="form-control" name="text_ar" id="editor1" placeholder="ادخل نص التوصية" rows="6"><?php echo e($testimonial->testimonial_ar->text); ?></textarea>
                                    <p class="help-block">ادخل نص التوصية</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </section>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.layouts.layouts', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>