<?php $__env->startSection('title', __('trans.patient_info')); ?>

<?php $__env->startSection('open-graph'); ?>
    <meta name="description" content="<?php echo e($og->description ? $og->description : $mainOpenGraph->description); ?>">
    <meta name="keywords" content="<?php echo e($og->key_words ? $og->key_words : $mainOpenGraph->key_words); ?>">
    <!-- open graph meta-->
    <meta property="og:title" content="<?php echo e($og->open_graph->og_title ? $og->open_graph->og_title : $mainOpenGraph->open_graph->og_title); ?>"/>
    <meta property="og:type" content="<?php echo e($og->open_graph->og_type ? $og->open_graph->og_type : $mainOpenGraph->open_graph->og_type); ?>"/>
    <meta property="og:url" content="<?php echo e(url($og->url)); ?>"/>
    <meta property="og:image" content="
    <?php if($og->open_graph->image_url): ?>
    <?php echo e($og->open_graph->image_url); ?>

    <?php elseif($og->open_graph->open_graph_image): ?>
    <?php echo e(asset($og->open_graph->open_graph_image->path)); ?>

    <?php else: ?>
    <?php echo e($mainOpenGraph->open_graph->image_url); ?>

    <?php endif; ?>
    "
    />
    <meta property="og:description" content="<?php echo e($og->open_graph->og_description ? $og->open_graph->og_description : $mainOpenGraph->open_graph->og_description); ?>"/>
    <meta property="og:site_name" content="<?php echo e($og->open_graph->og_site_name ? $og->open_graph->og_site_name : $mainOpenGraph->open_graph->og_site_name); ?>"/>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('canonical'); ?>
    <link rel="canonical" href="<?php echo e(url($og->url)); ?>"/>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header-code'); ?>
    <?php echo $headerCode->header_code ? $headerCode->header_code : ''; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>


    <!--============= Start banner =============-->
    <section class="banner text-center">
        <div class="overlay">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12">
                        <div class="info">
                            <h2><?php echo e(__("trans.website_title")); ?></h2>
                            <div class="navigation">
                                <ol class="breadcrumb">
                                    <li><a href="<?php echo e(url('/')); ?>"><?php echo e(__("trans.home")); ?></a></li>
                                    <li><a href="<?php echo e(url("/blog")); ?>"><?php echo e(__("trans.article")); ?></a></li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============= End banner =============-->
    <!--============= Start about_page =============-->
    <div class="blog_area">
        <div class="overlay-1">
            <div class="container">
                <div class="pattern-layer"></div>
                <div class="bar-hed text-center">
                    <h2 class=" text-center"><?php echo e(__("trans.articles")); ?> </h2>

                </div>
                <div class="row justify-content-center">
                    <?php if($blogs): ?>
                        <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-lg-4 col-md-6 col-sm-12">
                                <a href="<?php echo e(url("blog/".$blog->url)); ?>"></a>
                                <div class="blog_box"><a href="<?php echo e(url("blog/".$blog->url)); ?>">
                                        <div class="blog_img"><img src="<?php echo e($blog->image->path); ?>" alt="<?php echo e($blog->image->alt); ?>"></div>
                                    </a>
                                    <div class="blog_content"><a href="<?php echo e(url("blog/".$blog->url)); ?>">
                                        </a>
                                        <div class="blog_meta"><a href="<?php echo e(url("blog/".$blog->url)); ?>">
                                            </a><a href="<?php echo e(url("blog/".$blog->url)); ?>" class="date">
                                                
                                            </a>

                                        </div>
                                        <a href="<?php echo e(url("blog/".$blog->url)); ?>">
                                            <h4><?php echo e($blog->{'blog_'.currentLang()}->title); ?></h4>
                                            <p><?php echo e($blog->{'blog_'.currentLang()}->description); ?></p>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                    <?php endif; ?>
                    

                </div>

            </div>
        </div>
    </div>
    <!--============ End about_page ============-->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('website.layouts.layouts', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>