<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('customizedStyle'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('customizedScript'); ?>
    <script>
        $(function () {
            $('#example1').DataTable()
            $('#example2').DataTable({
                'paging'      : true,
                'lengthChange': true,
                'searching'   : true,
                'ordering'    : true,
                'info'        : true,
                'autoWidth'   : false
            })
        })
        var loc=location.href;
        if(loc =='<?php echo e(adminUrl("album?page=success-story")); ?>' || loc == '<?php echo e(adminUrl("album?page=medical-tourism")); ?>'){
            $(".box-header").hide();
        }else{

        }
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <section class="content-header">
        <h1>
            Albums
            <small>All Albums</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo e(adminUrl('/')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo e(adminUrl('/album')); ?>">Album</a></li>
            <li class="active">All Albums</li>
        </ol>
    </section>



    <section class="content">
        <div class="row">
            <!-- left column -->
            <div class="col-md-12">
                <div class="box box-primary" style="padding: 15px">
                    <div class="box-header with-border">
                        <h3 class="box-title">All Albums Info</h3>
                        <a href="<?php echo e(adminUrl('album/create')); ?>" class="btn btn-primary pull-right"><i class="fa fa-plus"></i> Add New Album </a>
                    </div>
                <?php echo $__env->make('dashboard.layouts.messages', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                <!-- /.box-header -->
                    <!-- form start -->
                    <table id="example2" class="table table-bordered table-hover">
                        <thead>
                        <tr>
                            <th>id</th>
                            <th>Thumbnail</th>
                            <th>Name</th>
                            <th>Type</th>
                            <th>Number of Items</th>
                            <th>Created at</th>
                            <th>Updated at</th>
                            <th>Actions</th>
                        </tr>
                        </thead>
                        <tfoot>
                        <tr>
                            <th>id</th>
                            <th>Thumbnail</th>
                            <th>Name</th>
                            <th>Type</th>
                            <th>Number of Items</th>
                            <th>Created at</th>
                            <th>Updated at</th>
                            <th>Actions</th>
                        </tr>
                        </tfoot>
                        <tbody>
                        <?php if($albums): ?>
                            <?php $__currentLoopData = $albums; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $album): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($album->id); ?></td>
                                    <td><img src="<?php echo e($album->image_id ? asset($album->image->path) : asset('dashboard/img/picture.png')); ?>" style="width: 50px" alt="slide image" > </td>
                                    <td><?php echo e($album->album_en->title); ?></td>
                                    <td><?php echo e($album->type == 1 ? 'Images' : 'Videos'); ?></td>
                                    <td><?php echo e($album->type == 1 ? count($album->images) : count($album->videos)); ?></td>
                                    <td><?php echo e($album->created_at ? $album->created_at->diffForHumans() : ''); ?></td>
                                    <td><?php echo e($album->updated_at ? $album->updated_at->diffForHumans() : ''); ?></td>
                                    <td>
                                        <a href="<?php echo e(route('album.edit', $album->id)); ?>" class style="font-size: 20px"><i class="fa fa-pencil-square-o"></i> </a>
                                        <?php if($album->type == 1): ?>
                                            <a href="<?php echo e(adminUrl('album/'.$album->id)); ?>" class style="font-size: 20px"><i class="fa fa-file-image-o" title="Show Album Images"></i> </a>
                                        <?php elseif($album->type == 2): ?>
                                            <a href="<?php echo e(adminUrl('video/?album='.$album->id)); ?>" class style="font-size: 20px"><i class="fa fa-video-camera" title="Show Album Videos"></i> </a>
                                        <?php endif; ?>
                                        <a href="<?php echo e($album->type == 1 ? adminUrl('album/'.$album->id.'/upload-to-gallery') : adminUrl('video/create')); ?>" class style="font-size: 20px">
                                            <i class="fa <?php echo e($album->type == 1 ? 'fa-upload' : 'fa-plus'); ?>"></i> </a>
                                        <button type="button" class data-toggle="modal" data-target="#delete<?php echo e($album->id); ?>" style="font-size: 20px">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>

                        </tbody>
                    </table>

                    <?php if($albums): ?>
                        <?php $__currentLoopData = $albums; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $album): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="modal modal-danger fade" id="delete<?php echo e($album->id); ?>">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span></button>
                                            <h4 class="modal-title">Delete Album</h4>
                                        </div>
                                        <div class="modal-body">
                                            <p>Are You Sure You Want To Delete Album <strong><?php echo e($album->album_en->title); ?></strong></p>
                                        </div>
                                        <div class="modal-footer">
                                            <form action="<?php echo e(route('album.destroy', $album->id)); ?>" method="post">
                                                <?php echo method_field('delete'); ?>
                                                <?php echo csrf_field(); ?>
                                                <div class="d-flex flex-row">
                                                    <button type="button" class="btn btn-outline-danger" data-dismiss="modal" style="margin-right: 5px">
                                                        cancel
                                                    </button>
                                                    <button type="submit" class="btn btn-danger">
                                                        Delete
                                                    </button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                    <!-- /.modal-content -->
                                </div>
                                <!-- /.modal-dialog -->
                            </div>
                            <!-- /.modal -->
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>

                </div>
            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.layouts.layouts', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>