<?php $__env->startSection('title', __('trans.success_stories')); ?>

<?php $__env->startSection('open-graph'); ?>
    <meta name="description" content="<?php echo e($og->description ? $og->description : $mainOpenGraph->description); ?>">
    <meta name="keywords" content="<?php echo e($og->key_words ? $og->key_words : $mainOpenGraph->key_words); ?>">
    <!-- open graph meta-->
    <meta property="og:title" content="<?php echo e($og->open_graph->og_title ? $og->open_graph->og_title : $mainOpenGraph->open_graph->og_title); ?>"/>
    <meta property="og:type" content="<?php echo e($og->open_graph->og_type ? $og->open_graph->og_type : $mainOpenGraph->open_graph->og_type); ?>"/>
    <meta property="og:url" content="<?php echo e(url($og->url)); ?>"/>
    <meta property="og:image" content="
    <?php if($og->open_graph->image_url): ?>
    <?php echo e($og->open_graph->image_url); ?>

    <?php elseif($og->open_graph->open_graph_image): ?>
    <?php echo e(asset($og->open_graph->open_graph_image->path)); ?>

    <?php else: ?>
    <?php echo e($mainOpenGraph->open_graph->image_url); ?>

    <?php endif; ?>
    "
    />
    <meta property="og:description" content="<?php echo e($og->open_graph->og_description ? $og->open_graph->og_description : $mainOpenGraph->open_graph->og_description); ?>"/>
    <meta property="og:site_name" content="<?php echo e($og->open_graph->og_site_name ? $og->open_graph->og_site_name : $mainOpenGraph->open_graph->og_site_name); ?>"/>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('canonical'); ?>
    <link rel="canonical" href="<?php echo e(url($og->url)); ?>"/>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header-code'); ?>
    <?php echo $headerCode->header_code ? $headerCode->header_code : ''; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>


    <!--============= Start banner =============-->
    <section class="banner text-center">
        <div class="overlay">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12">
                        <div class="info">
                            <h2><?php echo e(__("trans.website_title")); ?></h2>
                            <div class="navigation">
                                <ol class="breadcrumb">
                                    <li><a href="<?php echo e(url("/")); ?>"><?php echo e(__("trans.home")); ?></a></li>
                                    <li><a href="<?php echo e(url("/success-story")); ?>"> <?php echo e(__("trans.success_stories")); ?></a></li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============= End banner =============-->
    <div class="services">
        <div class="container">
            <h3 class="title"> <?php echo e(__("trans.success_stories")); ?></h3>

            <div class="row">
                <!--Start row-->
                <?php if($services): ?>
                    <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mainService): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-4 col-sm-6 col-xs-12">
                            <div class="single_service">
                                <a href="<?php echo e(url("/success-story/".$mainService->url)); ?>" class="wow zoomIn" data-wow-duration="1.5s">
                                    <img src="<?php echo e(assetPath($mainService->image->path)); ?>" alt="<?php echo e($mainService->image->alt); ?>">
                                    <div class="heading_service">
                                        <h3 class="front"><?php echo e($mainService->{'service_'.currentLang()}->title); ?></h3>
                                        <h3 class="back"><?php echo e($mainService->{'service_'.currentLang()}->title); ?></h3>
                                    </div>
                                </a>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <div class="col-md-4 col-sm-6 col-xs-12">
                        <div class="single_service">
                            <a href="single-service.html" target="_blank" class="wow zoomIn" data-wow-duration="1.5s">
                                <img src="<?php echo e(assetPath("website/imgs/services/white-3.jpg")); ?>" alt="">
                                <div class="heading_service">
                                    <h3 class="front">تكميم المعدة</h3>
                                    <h3 class="back">تكميم المعدة</h3>
                                </div>
                            </a>

                            <a href="single-service.html" target="_blank" class="wow zoomIn" data-wow-duration="1.5s">
                                <img src="<?php echo e(assetPath("website/imgs/services/white-2.jpg")); ?>" alt="">
                                <div class="heading_service">
                                    <h3 class="front">بالون المعدة</h3>
                                    <h3 class="back">بالون المعدة</h3>
                                </div>
                            </a>
                        </div>
                    </div>

                    <div class="col-md-4 col-sm-6 col-xs-12">
                        <div class="single_service">
                            <a href="single-service.html" target="_blank" class="wow zoomIn" data-wow-duration="1.5s">
                                <img src="<?php echo e(assetPath("website/imgs/services/white-4.jpg")); ?>" alt="">
                                <div class="heading_service">
                                    <h3 class="front">جراحات الاعادة</h3>
                                    <h3 class="back">جراحات الاعادة</h3>
                                </div>
                            </a>

                            <a href="single-service.html" target="_blank" class="wow zoomIn" data-wow-duration="1.5s">
                                <img src="<?php echo e(assetPath("website/imgs/services/whiteSmile.png")); ?>" alt="">
                                <div class="heading_service">
                                    <h3 class="front">برنامج تغذية</h3>
                                    <h3 class="back">برنامج تغذية</h3>
                                </div>
                            </a>
                        </div>
                    </div>

                    <div class="col-md-4 col-sm-6 col-xs-12">
                        <div class="single_service">
                            <a href="single-service.html" target="_blank" class="wow zoomIn" data-wow-duration="1.5s">
                                <img src="<?php echo e(assetPath("website/imgs/services/white-3.jpg")); ?>" alt="">
                                <div class="heading_service">
                                    <h3 class="front">علاج اضطرابات الغدد</h3>
                                    <h3 class="back">علاج اضطرابات الغدد</h3>
                                </div>
                            </a>

                            <a href="single-service.html" target="_blank" class="wow zoomIn" data-wow-duration="1.5s">
                                <img src="<?php echo e(assetPath("website/imgs/services/people-2597995_640.jpg")); ?>" alt="">
                                <div class="heading_service">
                                    <h3 class="front">تجميل بعد التخسيس</h3>
                                    <h3 class="back">تجميل بعد التخسيس</h3>
                                </div>
                            </a>
                        </div>
                    </div>
                <?php endif; ?>

            </div>
        </div>
    </div>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('website.layouts.layouts', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>