<?php


/**
* pathes file
*
* this file contain application pathes and links
*
* LICENSE: Open source
*
* @category   general
* @package    core system
* @subpackage parent
* @copyright  coderg
* @license    http://coderg.com
* @version    .01
* @link       http://coderg.com
* @since      2018
*/


// PATHES
global $routeConfig;

// APP_PATH get the name of root directory -> C:\xampp\htdocs\...
define("APP_PATH", substr(realpath(dirname(__FILE__)),0,-6));
//system path
define("SYSTEM_PATH", substr(APP_PATH,0,-5).DIRECTORY_SEPARATOR.'system'.DIRECTORY_SEPARATOR);
//system core directory
define("CORE_PATH", SYSTEM_PATH.'core'.DIRECTORY_SEPARATOR);
// DOMAIN_NAME get the domain name
define("DOMAIN_NAME", $_SERVER['SERVER_NAME']);
//CONFIG_PATH get all the configrations
define("CONFIG_PATH", APP_PATH."config".DIRECTORY_SEPARATOR);
// CUSTOMIZE_PATH get the path of cusomize folder -> C:\xampp\htdocs\...\customize\
define("CUSTOMIZE_PATH", APP_PATH."customize".DIRECTORY_SEPARATOR);
// CONTROLLER_PATH get the path of controller folder -> C:\xampp\htdocs\...\controller\
define("CONTROLLER_PATH", APP_PATH."controller".DIRECTORY_SEPARATOR);
//UPLOAD_PATH set Upload Directory
define("UPLOAD_PATH", APP_PATH."upload".DIRECTORY_SEPARATOR);
// APP_HELPER_PATH get the path of app_helper folder -> C:\xampp\htdocs\...\app_helper\
define("APP_HELPER_PATH", APP_PATH."app_helper".DIRECTORY_SEPARATOR);

// MODEL_PATH get the path of model folder -> C:\xampp\htdocs\...\model\
define("MODEL_PATH", APP_PATH."model".DIRECTORY_SEPARATOR);
// VIEW_PATH get the path of view folder -> C:\xampp\htdocs\...\view\
define("VIEW_PATH", APP_PATH."view".DIRECTORY_SEPARATOR);
// HELPER_PATH get the path of helper folder -> C:\xampp\htdocs\...\helper\
define("HELPER_PATH", SYSTEM_PATH."helper".DIRECTORY_SEPARATOR);
// LIBRARY_PATH get the path of library folder -> C:\xampp\htdocs\...\library\
define("LIBRARY_PATH", SYSTEM_PATH."library".DIRECTORY_SEPARATOR);
// BACKEND_CSS_PATH get the path of back end css folder -> C:\xampp\htdocs\..\customize\backend\css
define("BACKEND_CSS_PATH", CUSTOMIZE_PATH."backend".DIRECTORY_SEPARATOR."css".DIRECTORY_SEPARATOR);
// FRONTEND_CSS_PATH get the path of front end css folder -> C:\xampp\htdocs\...\customize\frontend\css\
define("FRONTEND_CSS_PATH", CUSTOMIZE_PATH."frontend".DIRECTORY_SEPARATOR."css".DIRECTORY_SEPARATOR);
// FRONTEND_IMAGES_PATH get the path of front end images folder -> C:\xampp\htdocs\...\customize\frontend\images\
define("FRONTEND_IMAGES_PATH", CUSTOMIZE_PATH."frontend".DIRECTORY_SEPARATOR."images".DIRECTORY_SEPARATOR);
// BACKEND_IMAGES_PATH get the path of back end images folder -> C:\xampp\htdocs\...\customize\backend\images\
define("BACKEND_IMAGES_PATH", CUSTOMIZE_PATH."backend".DIRECTORY_SEPARATOR."images".DIRECTORY_SEPARATOR);
// FRONTEND_JS_PATH get the path of front end js folder -> C:\xampp\htdocs\...\customize\frontend\js\
define("FRONTEND_JS_PATH", CUSTOMIZE_PATH."frontend".DIRECTORY_SEPARATOR."js".DIRECTORY_SEPARATOR);
// BACKEND_JS_PATH get the path of back end js folder -> C:\xampp\htdocs\...\customize\backend\js\
define("BACKEND_JS_PATH", CUSTOMIZE_PATH."backend".DIRECTORY_SEPARATOR."js".DIRECTORY_SEPARATOR);
// BACKEND_VENDOR_PATH get the path of back end vendor folder -> C:\xampp\htdocs\...\customize\backend\vendor\
define("BACKEND_VENDOR_PATH", CUSTOMIZE_PATH."backend".DIRECTORY_SEPARATOR."vendor".DIRECTORY_SEPARATOR);
// BACKEND_VENDOR_PATH get the path of back end vendor folder -> C:\xampp\htdocs\...\customize\frontend\vendor\
define("FRONTEND_VENDOR_PATH", CUSTOMIZE_PATH."frontend".DIRECTORY_SEPARATOR."vendor".DIRECTORY_SEPARATOR);
// BACK_END_TEMPLETE_PATH get the path of back end template folder -> C:\xampp\htdocs\...\view\template\backend\
define("BACK_END_TEMPLETE_PATH",VIEW_PATH."template".DIRECTORY_SEPARATOR."backend".DIRECTORY_SEPARATOR);
 // BACK_END_CONTROL_PATH get the path of back end control folder -> C:\xampp\htdocs\...\view\control\backend\
define("BACK_END_CONTROL_PATH",VIEW_PATH."control".DIRECTORY_SEPARATOR."backend".DIRECTORY_SEPARATOR);
// FRONT_END_TEMPLETE_PATH get the path of front end template folder -> C:\xampp\htdocs\...\view\template\frontend\
define("FRONT_END_TEMPLETE_PATH",VIEW_PATH."template".DIRECTORY_SEPARATOR."frontend".DIRECTORY_SEPARATOR);
 // FRONT_END_CONTROL_PATH get the path of front end control folder -> C:\xampp\htdocs\...\view\control\frontend\
define("FRONT_END_CONTROL_PATH",VIEW_PATH."control".DIRECTORY_SEPARATOR."frontend".DIRECTORY_SEPARATOR);
//ADMIN_PATH // get the path to admin folder
define("ADMIN_PATH",CONTROLLER_PATH.$routeConfig['adminPath']);
// ADMIN FOLDER
define("ADMIN_FOLDER",$routeConfig['adminPath']);



// URLS
define('PROJECT_NAME', 'perfecthealth');
define('SITE_URL', "http://".$_SERVER['SERVER_NAME'].'/'.PROJECT_NAME);
// CSS_FRONT_END_LINKget the LINK of front end css folder -> localhost/.../customize/frontend/css/
define("CSS_FRONT_END_LINK","customize/frontend/css/");
// CSS_BACK_END_LINK get the LINK of back end css folder -> localhost/.../customize/backend/css/
define("CSS_BACK_END_LINK","customize/backend/css/");
// IMAGES_FRONT_END_LINK get the LINK of front end images folder -> localhost/.../customize/frontend/images/
define("IMAGES_FRONT_END_LINK","customize/frontend/images/");
// IMAGES_BACK_END_LINK get the LINK of back end images folder -> localhost/.../customize/backend/images/
define("IMAGES_BACK_END_LINK","customize/backend/images/");
// JS_FRONT_END_LINK get the LINK of front end js folder -> C:/xampp/htdocs/.../customize/frontend/js/
define("JS_FRONT_END_LINK","customize/frontend/js/");
// JS_BACK_END_LINK get the LINK of back end js folder -> C:/xampp/htdocs/.../customize/backend/js/
define("JS_BACK_END_LINK","customize/backend/js/");
// VENDOR_BACK_END_LINK get the LINK of back end vendor folder -> C:/xampp/htdocs/.../customize/backend/vendor/
define("VENDOR_BACK_END_LINK","customize/backend/vendor/");
// VENDOR_FRONT_END_LINK get the LINK of back end vendor folder -> C:/xampp/htdocs/.../customize/frontend/vendor/
define("VENDOR_FRONT_END_LINK","customize/frontend/vendor/");
// upload Link
define("UPLOAD_LINK",SITE_URL."/app/upload/");
//VENDOR
define("VENDOR_LINK","vendor/");
//BASE URL "
define('BASE_URL', SITE_URL.'/');
define('BASE_URL_APP', SITE_URL.'/app/');



//add pathes to the main php path
$allPaths = get_include_path().
            PATH_SEPARATOR . MODEL_PATH. PATH_SEPARATOR . CONTROLLER_PATH . PATH_SEPARATOR .ADMIN_PATH. PATH_SEPARATOR.HELPER_PATH .PATH_SEPARATOR.
            LIBRARY_PATH.PATH_SEPARATOR.CONFIG_PATH.PATH_SEPARATOR.SYSTEM_PATH.PATH_SEPARATOR.CORE_PATH;

//set the added pathes
set_include_path($allPaths);

?>
